/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.trace.core;

import com.google.common.base.MoreObjects;
import java.math.BigInteger;
import java.util.Objects;

public class TraceId {
    private static final TraceId invalid = new TraceId(BigInteger.ZERO);
    private static final int TRACE_ID_BIT_LENGTH = 128;
    private final BigInteger traceId;

    public static TraceId invalid() {
        return invalid;
    }

    public TraceId(BigInteger traceId) {
        this.traceId = traceId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TraceId)) {
            return false;
        }
        TraceId that = (TraceId)obj;
        return Objects.equals(this.traceId, that.traceId);
    }

    public int hashCode() {
        return Objects.hashCode(this.traceId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("traceId", (Object)this.getApiString()).toString();
    }

    public boolean isValid() {
        return this.traceId.signum() > 0 && this.traceId.bitLength() <= 128;
    }

    public BigInteger getTraceId() {
        return this.traceId;
    }

    public String getApiString() {
        return String.format("%032x", this.traceId);
    }
}

