/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImmutableSet<E>
implements Set<E>,
Serializable {
    private static final ImmutableSet<?> EMPTY_IMMUTABLE_SET = new EmptyImmutableSet();
    private final int hashCode;
    private static final int MAX_TABLE_SIZE = 0x40000000;
    private static final int CUTOFF = 0x20000000;

    public static <E> ImmutableSet<E> of() {
        return EMPTY_IMMUTABLE_SET;
    }

    public static <E> ImmutableSet<E> of(E element) {
        return new SingletonImmutableSet<E>(element, element.hashCode());
    }

    public static <E> ImmutableSet<E> of(E ... elements) {
        switch (elements.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements[0]);
            }
        }
        return ImmutableSet.create(Arrays.asList(elements), elements.length);
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> elements) {
        if (elements instanceof ImmutableSet) {
            ImmutableSet set = (ImmutableSet)elements;
            return set;
        }
        int size = Iterables.size(elements);
        switch (size) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements.iterator().next());
            }
        }
        return ImmutableSet.create(elements, size);
    }

    private ImmutableSet(int hashCode) {
        this.hashCode = hashCode;
    }

    @Override
    public abstract boolean contains(@Nullable Object var1);

    @Override
    public boolean containsAll(Collection<?> targets) {
        for (Object target : targets) {
            if (this.contains(target)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean add(E newElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean remove(Object oldElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean removeAll(Collection<?> oldElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> elementsToKeep) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    private static <E> ImmutableSet<E> create(Iterable<? extends E> iterable, int count) {
        int tableSize = ImmutableSet.chooseTableSize(count);
        Object[] table = new Object[tableSize];
        int mask = tableSize - 1;
        ArrayList<E> elements = new ArrayList<E>(count);
        int hashCode = 0;
        block0: for (E element : iterable) {
            int hash = element.hashCode();
            int i = ImmutableSet.smear(hash);
            while (true) {
                int index;
                Object value;
                if ((value = table[index = i & mask]) == null) {
                    table[index] = element;
                    elements.add(element);
                    hashCode += hash;
                    continue block0;
                }
                if (value.equals(element)) continue block0;
                ++i;
            }
        }
        return elements.size() == 1 ? new SingletonImmutableSet(elements.get(0), hashCode) : new RegularImmutableSet(elements.toArray(), table, mask, hashCode);
    }

    static int chooseTableSize(int setSize) {
        if (setSize < 0x20000000) {
            return Integer.highestOneBit(setSize) << 2;
        }
        Preconditions.checkArgument(setSize < 0x40000000, "set too large");
        return 0x40000000;
    }

    private static int smear(int hashCode) {
        hashCode ^= hashCode >>> 20 ^ hashCode >>> 12;
        return hashCode ^ hashCode >>> 7 ^ hashCode >>> 4;
    }

    private Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] elements) {
            this.elements = elements;
        }

        Object readResolve() {
            return ImmutableSet.of(this.elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegularImmutableSet<E>
    extends ImmutableSet<E> {
        final Object[] elements;
        final Object[] table;
        final int mask;

        RegularImmutableSet(Object[] elements, Object[] table, int mask, int hashCode) {
            super(hashCode);
            this.elements = elements;
            this.table = table;
            this.mask = mask;
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return Iterators.forArray(this.elements);
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            System.arraycopy(this.elements, 0, array, 0, this.size());
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.size();
            if (array.length < size) {
                array = ObjectArrays.newArray(array, size);
            } else if (array.length > size) {
                array[size] = null;
            }
            System.arraycopy(this.elements, 0, array, 0, size);
            return array;
        }

        @Override
        public boolean contains(Object target) {
            if (target == null) {
                return false;
            }
            int i = ImmutableSet.smear(target.hashCode());
            Object candidate;
            while ((candidate = this.table[i & this.mask]) != null) {
                if (candidate.equals(target)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            if (targets == this) {
                return true;
            }
            if (!(targets instanceof RegularImmutableSet)) {
                return super.containsAll(targets);
            }
            if (targets.size() > this.size()) {
                return false;
            }
            for (Object target : ((RegularImmutableSet)targets).elements) {
                if (this.contains(target)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ImmutableSet && this.hashCode() != object.hashCode()) {
                return false;
            }
            if (object instanceof Set) {
                Set that = (Set)object;
                return this.size() == that.size() && this.containsAll(that);
            }
            return false;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.size() * 16);
            result.append('[').append(this.elements[0].toString());
            for (int i = 1; i < this.size(); ++i) {
                result.append(", ").append(this.elements[i].toString());
            }
            return result.append(']').toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingletonImmutableSet<E>
    extends ImmutableSet<E> {
        final E element;

        SingletonImmutableSet(E element, int hashCode) {
            super(hashCode);
            this.element = element;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object target) {
            return this.element.equals(target);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                boolean done;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public E next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return SingletonImmutableSet.this.element;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public <T> T[] toArray(T[] array) {
            if (array.length == 0) {
                array = ObjectArrays.newArray(array, 1);
            } else if (array.length > 1) {
                array[1] = null;
            }
            array[0] = this.element;
            return array;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Set) {
                Set set = (Set)object;
                return set.size() == 1 && this.contains(set.iterator().next());
            }
            return false;
        }

        public String toString() {
            String elementToString = this.element.toString();
            return new StringBuilder(elementToString.length() + 2).append('[').append(elementToString).append(']').toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EmptyImmutableSet
    extends ImmutableSet<Object> {
        EmptyImmutableSet() {
            super(0);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object target) {
            return false;
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public Object[] toArray() {
            return ObjectArrays.EMPTY_ARRAY;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public boolean containsAll(Collection<?> targets) {
            return targets.isEmpty();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof Set && ((Set)object).isEmpty();
        }

        public String toString() {
            return "[]";
        }
    }
}

