/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ordering<T>
implements Comparator<T>,
Serializable {
    public static <T> Ordering<T> forComparator(final Comparator<T> comparator) {
        return new Ordering<T>(){

            @Override
            public int compare(T a, T b) {
                return comparator.compare(a, b);
            }
        };
    }

    @Override
    public Ordering<T> reverseOrder() {
        return new ReverseOrdering(this);
    }

    public int binarySearch(List<? extends T> sortedList, T key) {
        return Collections.binarySearch(sortedList, key, this);
    }

    public void sort(List<? extends T> list) {
        Collections.sort(list, this);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> iterable) {
        ArrayList<E> list = Lists.newArrayList(iterable);
        this.sort(list);
        return list;
    }

    public <E extends T> E max(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        E maxSoFar = iterator.next();
        while (iterator.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator.next());
        }
        return maxSoFar;
    }

    public <E extends T> E max(E a, E b, E c, E ... rest) {
        E maxSoFar = this.max(this.max(a, b), c);
        for (E r : rest) {
            maxSoFar = this.max(maxSoFar, r);
        }
        return maxSoFar;
    }

    public <E extends T> E max(E a, E b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    public <E extends T> E min(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        E minSoFar = iterator.next();
        while (iterator.hasNext()) {
            minSoFar = this.min(minSoFar, iterator.next());
        }
        return minSoFar;
    }

    public <E extends T> E min(E a, E b, E c, E ... rest) {
        E minSoFar = this.min(this.min(a, b), c);
        for (E r : rest) {
            minSoFar = this.min(minSoFar, r);
        }
        return minSoFar;
    }

    public <E extends T> E min(E a, E b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReverseOrdering<T>
    extends Ordering<T> {
        final Ordering<T> forwardOrder;

        public ReverseOrdering(Ordering<T> forwardOrder) {
            this.forwardOrder = Preconditions.checkNotNull(forwardOrder);
        }

        @Override
        public Ordering<T> reverseOrder() {
            return this.forwardOrder;
        }

        @Override
        public int compare(T a, T b) {
            return this.forwardOrder.compare(b, a);
        }

        public int hashCode() {
            return -this.forwardOrder.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof ReverseOrdering && this.forwardOrder.equals(((ReverseOrdering)other).forwardOrder);
        }
    }
}

