/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Synchronized {
    private Synchronized() {
    }

    static <E> Collection<E> collection(Collection<E> collection, Object lock) {
        return new SynchronizedCollection<E>(collection, lock);
    }

    public static <E> Set<E> set(Set<E> set, Object lock) {
        return new SynchronizedSet<E>(set, lock);
    }

    static <E> SortedSet<E> sortedSet(SortedSet<E> set, Object lock) {
        return new SynchronizedSortedSet<E>(set, lock);
    }

    static <E> List<E> list(List<E> list, Object lock) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<E>(list, lock) : new SynchronizedList<E>(list, lock);
    }

    public static <E> Multiset<E> multiset(Multiset<E> multiset, Object lock) {
        return new SynchronizedMultiset<E>(multiset, lock);
    }

    public static <K, V> Multimap<K, V> multimap(Multimap<K, V> multimap, Object lock) {
        return new SynchronizedMultimap<K, V>(multimap, lock);
    }

    private static <E> Collection<E> typePreservingCollection(Collection<E> collection, Object lock) {
        if (collection instanceof SortedSet) {
            return Synchronized.sortedSet((SortedSet)collection, lock);
        }
        if (collection instanceof Set) {
            return Synchronized.set((Set)collection, lock);
        }
        if (collection instanceof List) {
            return Synchronized.list((List)collection, lock);
        }
        return Synchronized.collection(collection, lock);
    }

    public static <E> Set<E> typePreservingSet(Set<E> set, Object lock) {
        if (set instanceof SortedSet) {
            return Synchronized.sortedSet((SortedSet)set, lock);
        }
        return Synchronized.set(set, lock);
    }

    public static <K, V> Map<K, V> map(Map<K, V> map, Object lock) {
        return new SynchronizedMap<K, V>(map, lock);
    }

    public static <K, V> BiMap<K, V> biMap(BiMap<K, V> bimap, Object lock) {
        return new SynchronizedBiMap<K, V>(bimap, lock, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedAsMapValues<V>
    extends SynchronizedCollection<Collection<V>> {
        private static final long serialVersionUID = 794109514199117015L;

        SynchronizedAsMapValues(Collection<Collection<V>> delegate, Object lock) {
            super(delegate, lock);
        }

        @Override
        public Iterator<Collection<V>> iterator() {
            return new ForwardingIterator<Collection<V>>(super.iterator()){

                @Override
                public Collection<V> next() {
                    return Synchronized.typePreservingCollection((Collection)super.next(), SynchronizedAsMapValues.this.lock);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.toArrayImpl(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] array) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.toArrayImpl(this, array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.containsImpl(this, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.containsAllImpl(this, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.removeImpl(this, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.removeAllImpl(this, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.retainAllImpl(this, c);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedAsMap<K, V>
    extends SynchronizedMap<K, Collection<V>> {
        private final Map<K, Collection<V>> delegate;
        private volatile transient Set<Map.Entry<K, Collection<V>>> entrySet;
        private volatile transient Collection<Collection<V>> values;
        private static final long serialVersionUID = 794109514199117015L;

        public SynchronizedAsMap(Map<K, Collection<V>> delegate, Object lock) {
            super(delegate, lock);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> get(Object key) {
            Object object = this.lock;
            synchronized (object) {
                Collection collection = (Collection)super.get(key);
                return collection == null ? null : Synchronized.typePreservingCollection(collection, this.lock);
            }
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new SynchronizedAsMapEntries<K, V>(this.delegate.entrySet(), this.lock);
            }
            return this.entrySet;
        }

        @Override
        public Collection<Collection<V>> values() {
            if (this.values == null) {
                this.values = new SynchronizedAsMapValues<V>(this.delegate.values(), this.lock);
            }
            return this.values;
        }

        @Override
        public boolean containsValue(Object o) {
            return this.values().contains(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedBiMap<K, V>
    extends SynchronizedMap<K, V>
    implements BiMap<K, V>,
    Serializable {
        private final BiMap<K, V> delegate;
        private volatile transient Set<V> values;
        private volatile transient BiMap<V, K> inverse;
        private static final long serialVersionUID = -8892589047022295017L;

        public SynchronizedBiMap(BiMap<K, V> delegate, Object lock, BiMap<V, K> inverse) {
            super(delegate, lock);
            this.delegate = delegate;
            this.inverse = inverse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<V> values() {
            Object object = this.lock;
            synchronized (object) {
                if (this.values == null) {
                    this.values = Synchronized.set(this.delegate.values(), this.lock);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V forcePut(K key, V value) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.forcePut(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BiMap<V, K> inverse() {
            Object object = this.lock;
            synchronized (object) {
                if (this.inverse == null) {
                    this.inverse = new SynchronizedBiMap<K, V>(this.delegate.inverse(), this.lock, this);
                }
                return this.inverse;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private final Map<K, V> delegate;
        protected final Object lock;
        private volatile transient Set<K> keySet;
        private volatile transient Collection<V> values;
        private volatile transient Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = -2739593476673006162L;

        public SynchronizedMap(Map<K, V> delegate, Object lock) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.lock = lock == null ? this : lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.lock;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Synchronized.set(this.delegate.entrySet(), this.lock);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.lock;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = Synchronized.set(this.delegate.keySet(), this.lock);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.putAll(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object key) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.lock;
            synchronized (object) {
                if (this.values == null) {
                    this.values = Synchronized.collection(this.delegate.values(), this.lock);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object other) {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).equals(other);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedAsMapEntries<K, V>
    extends SynchronizedSet<Map.Entry<K, Collection<V>>> {
        private final Set<Map.Entry<K, Collection<V>>> delegate;
        private static final long serialVersionUID = 794109514199117015L;

        public SynchronizedAsMapEntries(Set<Map.Entry<K, Collection<V>>> delegate, Object lock) {
            super(delegate, lock);
            this.delegate = delegate;
        }

        @Override
        public Iterator<Map.Entry<K, Collection<V>>> iterator() {
            return new ForwardingIterator<Map.Entry<K, Collection<V>>>(super.iterator()){

                @Override
                public Map.Entry<K, Collection<V>> next() {
                    return new ForwardingMapEntry<K, Collection<V>>((Map.Entry)super.next()){

                        @Override
                        public Collection<V> getValue() {
                            return Synchronized.typePreservingCollection((Collection)super.getValue(), SynchronizedAsMapEntries.this.lock);
                        }
                    };
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.toArrayImpl(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] array) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.toArrayImpl(this, array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return Maps.containsEntryImpl(this.delegate, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.containsAllImpl(this, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingSet.equalsImpl(this, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return Maps.removeEntryImpl(this.delegate, o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.removeAllImpl(this, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return ForwardingCollection.retainAllImpl(this, c);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SynchronizedMultimap<K, V>
    implements Multimap<K, V>,
    Serializable {
        final Multimap<K, V> delegate;
        final Object lock;
        volatile transient Set<K> keySet;
        volatile transient Collection<V> values;
        volatile transient Collection<Map.Entry<K, V>> entries;
        volatile transient Map<K, Collection<V>> asMap;
        volatile transient Multiset<K> keys;
        private static final long serialVersionUID = 7083631791577112787L;

        SynchronizedMultimap(Multimap<K, V> delegate, Object lock) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.lock = lock == null ? this : lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsEntry(Object key, Object value) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.containsEntry(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> get(K key) {
            Object object = this.lock;
            synchronized (object) {
                return Synchronized.typePreservingCollection(this.delegate.get(key), this.lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean put(K key, V value) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(K key, Iterable<? extends V> values) {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.putAll(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Multimap<? extends K, ? extends V> multimap) {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.putAll(multimap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> replaceValues(K key, Iterable<? extends V> values) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.replaceValues(key, values);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key, Object value) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> removeAll(Object key) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.removeAll(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.lock;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = Synchronized.typePreservingSet(this.delegate.keySet(), this.lock);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.lock;
            synchronized (object) {
                if (this.values == null) {
                    this.values = Synchronized.collection(this.delegate.values(), this.lock);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Map.Entry<K, V>> entries() {
            Object object = this.lock;
            synchronized (object) {
                if (this.entries == null) {
                    this.entries = Synchronized.typePreservingCollection(this.delegate.entries(), this.lock);
                }
                return this.entries;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<K, Collection<V>> asMap() {
            Object object = this.lock;
            synchronized (object) {
                if (this.asMap == null) {
                    this.asMap = new SynchronizedAsMap<K, V>(this.delegate.asMap(), this.lock);
                }
                return this.asMap;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Multiset<K> keys() {
            Object object = this.lock;
            synchronized (object) {
                if (this.keys == null) {
                    this.keys = Synchronized.multiset(this.delegate.keys(), this.lock);
                }
                return this.keys;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object other) {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).equals(other);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedMultiset<E>
    extends SynchronizedCollection<E>
    implements Multiset<E> {
        private final Multiset<E> delegate;
        private volatile transient Set<E> elementSet;
        private volatile transient Set<Multiset.Entry<E>> entrySet;
        private static final long serialVersionUID = -1644906276741825553L;

        public SynchronizedMultiset(Multiset<E> delegate, Object lock) {
            super(delegate, lock);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int count(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.count(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e, int n) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.add(e, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int remove(Object o, int n) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.remove(o, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int removeAllOccurrences(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.removeAllOccurrences(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<E> elementSet() {
            Object object = this.lock;
            synchronized (object) {
                if (this.elementSet == null) {
                    this.elementSet = Synchronized.typePreservingSet(this.delegate.elementSet(), this.lock);
                }
                return this.elementSet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Multiset.Entry<E>> entrySet() {
            Object object = this.lock;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = Synchronized.typePreservingSet(this.delegate.entrySet(), this.lock);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 700333540904833406L;

        public SynchronizedRandomAccessList(List<E> list, Object lock) {
            super(list, lock);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private final List<E> delegate;
        private static final long serialVersionUID = -774310967040756161L;

        public SynchronizedList(List<E> delegate, Object lock) {
            super(delegate, lock);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.add(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.addAll(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.lastIndexOf(o);
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.delegate.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.delegate.listIterator(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E element) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.set(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.lock;
            synchronized (object) {
                return Synchronized.list(this.delegate.subList(fromIndex, toIndex), this.lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private final SortedSet<E> delegate;
        private static final long serialVersionUID = 257153630837525973L;

        public SynchronizedSortedSet(SortedSet<E> delegate, Object lock) {
            super(delegate, lock);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            Object object = this.lock;
            synchronized (object) {
                return Synchronized.sortedSet(this.delegate.subSet(fromElement, toElement), this.lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> headSet(E toElement) {
            Object object = this.lock;
            synchronized (object) {
                return Synchronized.sortedSet(this.delegate.headSet(toElement), this.lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> tailSet(E fromElement) {
            Object object = this.lock;
            synchronized (object) {
                return Synchronized.sortedSet(this.delegate.tailSet(fromElement), this.lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E first() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E last() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.last();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private final Set<E> delegate;
        private static final long serialVersionUID = -1182284868190508661L;

        public SynchronizedSet(Set<E> delegate, Object lock) {
            super(delegate, lock);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.lock;
            synchronized (object) {
                return ((Object)this.delegate).hashCode();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SynchronizedCollection<E>
    extends SynchronizedObject
    implements Collection<E> {
        private final Collection<E> delegate;
        private static final long serialVersionUID = 184628707078353613L;

        public SynchronizedCollection(Collection<E> delegate, Object lock) {
            super(delegate, lock);
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E o) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.add(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.addAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.lock;
            synchronized (object) {
                this.delegate.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.containsAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.isEmpty();
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.delegate.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.removeAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.toArray(a);
            }
        }
    }

    static class SynchronizedObject
    implements Serializable {
        private final Object delegate;
        protected final Object lock;
        private static final long serialVersionUID = -5880321047335989868L;

        public SynchronizedObject(Object delegate, Object lock) {
            this.delegate = Preconditions.checkNotNull(delegate);
            this.lock = lock == null ? this : lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.lock;
            synchronized (object) {
                return this.delegate.toString();
            }
        }
    }
}

