/*
 * Decompiled with CFR 0.152.
 */
package dagger.android.shaded.auto.common;

import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum Visibility {
    PRIVATE,
    DEFAULT,
    PROTECTED,
    PUBLIC;

    private static final @Nullable ElementKind MODULE;

    public static Visibility ofElement(Element element) {
        Preconditions.checkNotNull((Object)element);
        if (element.getKind().equals((Object)ElementKind.PACKAGE) || element.getKind().equals((Object)MODULE)) {
            return PUBLIC;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            return PRIVATE;
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            return PROTECTED;
        }
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return PUBLIC;
        }
        return DEFAULT;
    }

    public static Visibility effectiveVisibilityOfElement(Element element) {
        Preconditions.checkNotNull((Object)element);
        Visibility effectiveVisibility = PUBLIC;
        for (Element currentElement = element; currentElement != null; currentElement = currentElement.getEnclosingElement()) {
            effectiveVisibility = (Visibility)((Object)Ordering.natural().min((Object)effectiveVisibility, (Object)Visibility.ofElement(currentElement)));
        }
        return effectiveVisibility;
    }

    static {
        MODULE = (ElementKind)((Object)Enums.getIfPresent(ElementKind.class, (String)"MODULE").orNull());
    }
}

