/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding;
import dagger.internal.codegen.AutoValue_MembersInjectionBinding_InjectionSite;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequestFactory;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scopes;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.model.RequestKind;
import dagger.model.Scope;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;

final class BindingFactory {
    private final DaggerTypes types;
    private final KeyFactory keyFactory;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final DaggerElements elements;
    private final ElementVisitor<Optional<MembersInjectionBinding.InjectionSite>, DeclaredType> injectionSiteVisitor = new ElementKindVisitor6<Optional<MembersInjectionBinding.InjectionSite>, DeclaredType>(Optional.empty()){

        @Override
        public Optional<MembersInjectionBinding.InjectionSite> visitExecutableAsMethod(ExecutableElement e, DeclaredType type) {
            return Optional.of(BindingFactory.this.injectionSiteForInjectMethod(e, type));
        }

        @Override
        public Optional<MembersInjectionBinding.InjectionSite> visitVariableAsField(VariableElement e, DeclaredType type) {
            return MoreElements.isAnnotationPresent(e, Inject.class) && !e.getModifiers().contains((Object)Modifier.PRIVATE) && !e.getModifiers().contains((Object)Modifier.STATIC) ? Optional.of(BindingFactory.this.injectionSiteForInjectField(e, type)) : Optional.empty();
        }
    };

    @Inject
    BindingFactory(DaggerTypes types, DaggerElements elements, KeyFactory keyFactory, DependencyRequestFactory dependencyRequestFactory) {
        this.types = types;
        this.elements = elements;
        this.keyFactory = keyFactory;
        this.dependencyRequestFactory = dependencyRequestFactory;
    }

    ProvisionBinding injectionBinding(ExecutableElement constructorElement, Optional<TypeMirror> resolvedType) {
        Preconditions.checkArgument((boolean)constructorElement.getKind().equals((Object)ElementKind.CONSTRUCTOR));
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(constructorElement, Inject.class));
        Preconditions.checkArgument((!InjectionAnnotations.getQualifier(constructorElement).isPresent() ? 1 : 0) != 0);
        ExecutableType constructorType = MoreTypes.asExecutable(constructorElement.asType());
        DeclaredType constructedType = MoreTypes.asDeclared(constructorElement.getEnclosingElement().asType());
        if (!constructedType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
            DeclaredType resolved = MoreTypes.asDeclared(resolvedType.get());
            Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(constructedType)), (String)"erased expected type: %s, erased actual type: %s", (Object)this.types.erasure(resolved), (Object)this.types.erasure(constructedType));
            constructorType = MoreTypes.asExecutable(this.types.asMemberOf(resolved, constructorElement));
            constructedType = resolved;
        }
        Key key = this.keyFactory.forInjectConstructorWithResolvedType(constructedType);
        ImmutableSet<DependencyRequest> provisionDependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(constructorElement.getParameters(), constructorType.getParameterTypes());
        ProvisionBinding.Builder builder = ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(constructorElement)).key(key)).provisionDependencies((Iterable<DependencyRequest>)provisionDependencies).injectionSites(this.getInjectionSites(constructedType)).kind(BindingKind.INJECTION)).scope(Scopes.uniqueScopeOf(constructorElement.getEnclosingElement()));
        TypeElement bindingTypeElement = MoreElements.asType(constructorElement.getEnclosingElement());
        if (Binding.hasNonDefaultTypeParameters(bindingTypeElement, key.type(), this.types)) {
            builder.unresolved(this.injectionBinding(constructorElement, Optional.empty()));
        }
        return (ProvisionBinding)builder.build();
    }

    ProvisionBinding providesMethodBinding(ExecutableElement providesMethod, TypeElement contributedBy) {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)this.setMethodBindingProperties(ProvisionBinding.builder(), providesMethod, contributedBy, this.keyFactory.forProvidesMethod(providesMethod, contributedBy), this::providesMethodBinding).kind(BindingKind.PROVISION)).scope(Scopes.uniqueScopeOf(providesMethod)).nullableType(ConfigurationAnnotations.getNullableType(providesMethod))).build();
    }

    ProductionBinding producesMethodBinding(ExecutableElement producesMethod, TypeElement contributedBy) {
        ProductionBinding.Builder builder = ((ProductionBinding.Builder)this.setMethodBindingProperties(ProductionBinding.builder(), producesMethod, contributedBy, this.keyFactory.forProducesMethod(producesMethod, contributedBy), this::producesMethodBinding).kind(BindingKind.PRODUCTION)).productionKind(ProductionBinding.ProductionKind.fromProducesMethod(producesMethod)).thrownTypes(producesMethod.getThrownTypes()).executorRequest(this.dependencyRequestFactory.forProductionImplementationExecutor()).monitorRequest(this.dependencyRequestFactory.forProductionComponentMonitor());
        return (ProductionBinding)builder.build();
    }

    private <C extends ContributionBinding, B extends ContributionBinding.Builder<C, B>> B setMethodBindingProperties(B builder, ExecutableElement method, TypeElement contributedBy, Key key, BiFunction<ExecutableElement, TypeElement, C> create) {
        Preconditions.checkArgument((boolean)method.getKind().equals((Object)ElementKind.METHOD));
        ExecutableType methodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributedBy.asType()), method));
        if (!this.types.isSameType(methodType, method.asType())) {
            builder.unresolved((ContributionBinding)((ContributionBinding)create.apply(method, MoreElements.asType(method.getEnclosingElement()))));
        }
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.fromBindingMethod(method))).bindingElement(method)).contributingModule(contributedBy)).key(key)).dependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forRequiredResolvedVariables(method.getParameters(), methodType.getParameterTypes()))).wrappedMapKeyAnnotation(MoreAnnotationMirrors.wrapOptionalInEquivalence(MapKeys.getMapKey(method)));
    }

    ContributionBinding syntheticMultibinding(Key key, Iterable<ContributionBinding> multibindingContributions) {
        ContributionBinding.Builder builder = this.multibindingRequiresProduction(key, multibindingContributions) ? ProductionBinding.builder() : ProvisionBinding.builder();
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.UNIQUE)).key(key)).dependencies((Iterable<DependencyRequest>)this.dependencyRequestFactory.forMultibindingContributions(key, multibindingContributions))).kind(ContributionBinding.bindingKindForMultibindingKey(key))).build();
    }

    private boolean multibindingRequiresProduction(Key key, Iterable<ContributionBinding> multibindingContributions) {
        MapType mapType;
        if (MapType.isMap(key) ? (mapType = MapType.from(key)).valuesAreTypeOf(Producer.class) || mapType.valuesAreTypeOf(Produced.class) : SetType.isSet(key) && SetType.from(key).elementsAreTypeOf(Produced.class)) {
            return true;
        }
        return Iterables.any(multibindingContributions, binding -> binding.bindingType().equals((Object)BindingType.PRODUCTION));
    }

    ProvisionBinding componentBinding(TypeElement componentDefinitionType) {
        Preconditions.checkNotNull((Object)componentDefinitionType);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(componentDefinitionType)).key(this.keyFactory.forType(componentDefinitionType.asType()))).kind(BindingKind.COMPONENT)).build();
    }

    ProvisionBinding componentDependencyBinding(ComponentRequirement dependency) {
        Preconditions.checkNotNull((Object)dependency);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(dependency.typeElement())).key(this.keyFactory.forType(dependency.type()))).kind(BindingKind.COMPONENT_DEPENDENCY)).build();
    }

    ContributionBinding componentDependencyMethodBinding(ComponentDescriptor componentDescriptor, ExecutableElement dependencyMethod) {
        Preconditions.checkArgument((boolean)dependencyMethod.getKind().equals((Object)ElementKind.METHOD));
        Preconditions.checkArgument((boolean)dependencyMethod.getParameters().isEmpty());
        ContributionBinding.Builder builder = componentDescriptor.kind().equals((Object)ComponentDescriptor.Kind.PRODUCTION_COMPONENT) && ComponentDescriptor.isComponentProductionMethod(this.elements, dependencyMethod) ? ((ProductionBinding.Builder)((ProductionBinding.Builder)ProductionBinding.builder().key(this.keyFactory.forProductionComponentMethod(dependencyMethod))).kind(BindingKind.COMPONENT_PRODUCTION)).thrownTypes(dependencyMethod.getThrownTypes()) : ((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().key(this.keyFactory.forComponentMethod(dependencyMethod))).nullableType(ConfigurationAnnotations.getNullableType(dependencyMethod))).kind(BindingKind.COMPONENT_PROVISION)).scope(Scopes.uniqueScopeOf(dependencyMethod));
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(ContributionType.UNIQUE)).bindingElement(dependencyMethod)).build();
    }

    ProvisionBinding boundInstanceBinding(ComponentDescriptor.BuilderRequirementMethod bindsInstanceMethod) {
        Preconditions.checkArgument((boolean)bindsInstanceMethod.method().getKind().equals((Object)ElementKind.METHOD));
        Preconditions.checkArgument((bindsInstanceMethod.method().getParameters().size() == 1 ? 1 : 0) != 0);
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(bindsInstanceMethod.method())).key(bindsInstanceMethod.requirement().key().get())).nullableType(ConfigurationAnnotations.getNullableType((Element)Iterables.getOnlyElement(bindsInstanceMethod.method().getParameters())))).kind(BindingKind.BOUND_INSTANCE)).build();
    }

    ProvisionBinding subcomponentBuilderBinding(ExecutableElement subcomponentBuilderMethod, TypeElement component) {
        Preconditions.checkArgument((boolean)subcomponentBuilderMethod.getKind().equals((Object)ElementKind.METHOD));
        Preconditions.checkArgument((boolean)subcomponentBuilderMethod.getParameters().isEmpty());
        Key key = this.keyFactory.forSubcomponentBuilderMethod(subcomponentBuilderMethod, MoreTypes.asDeclared(component.asType()));
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).bindingElement(subcomponentBuilderMethod)).key(key)).kind(BindingKind.SUBCOMPONENT_BUILDER)).build();
    }

    ProvisionBinding subcomponentBuilderBinding(ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations) {
        SubcomponentDeclaration subcomponentDeclaration = (SubcomponentDeclaration)subcomponentDeclarations.iterator().next();
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(subcomponentDeclaration.key())).kind(BindingKind.SUBCOMPONENT_BUILDER)).build();
    }

    ContributionBinding delegateBinding(DelegateDeclaration delegateDeclaration, ContributionBinding actualBinding) {
        switch (actualBinding.bindingType()) {
            case PRODUCTION: {
                return this.buildDelegateBinding((ContributionBinding.Builder<?, ?>)ProductionBinding.builder().nullableType(actualBinding.nullableType()), delegateDeclaration, Producer.class);
            }
            case PROVISION: {
                return this.buildDelegateBinding((ContributionBinding.Builder<?, ?>)ProvisionBinding.builder().scope(Scopes.uniqueScopeOf(delegateDeclaration.bindingElement().get())).nullableType(actualBinding.nullableType()), delegateDeclaration, Provider.class);
            }
        }
        throw new AssertionError((Object)("bindingType: " + actualBinding));
    }

    ContributionBinding unresolvedDelegateBinding(DelegateDeclaration delegateDeclaration) {
        return this.buildDelegateBinding(ProvisionBinding.builder().scope(Scopes.uniqueScopeOf(delegateDeclaration.bindingElement().get())), delegateDeclaration, Provider.class);
    }

    private ContributionBinding buildDelegateBinding(ContributionBinding.Builder<?, ?> builder, DelegateDeclaration delegateDeclaration, Class<?> frameworkType) {
        return ((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)((ContributionBinding.Builder)builder.contributionType(delegateDeclaration.contributionType())).bindingElement(delegateDeclaration.bindingElement().get())).contributingModule(delegateDeclaration.contributingModule().get())).key(this.keyFactory.forDelegateBinding(delegateDeclaration, frameworkType))).dependencies(delegateDeclaration.delegateRequest())).wrappedMapKeyAnnotation(delegateDeclaration.wrappedMapKey())).kind(BindingKind.DELEGATE)).build();
    }

    ProvisionBinding releasableReferenceManagerBinding(Scope scope) {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(this.keyFactory.forReleasableReferenceManager(scope))).kind(BindingKind.RELEASABLE_REFERENCE_MANAGER)).build();
    }

    ProvisionBinding typedReleasableReferenceManagerBinding(Scope scope, DeclaredType metadataType) {
        return (ProvisionBinding)((ProvisionBinding.Builder)this.releasableReferenceManagerBinding(scope).toBuilder().key(this.keyFactory.forTypedReleasableReferenceManager(scope, metadataType))).build();
    }

    ProvisionBinding setOfReleasableReferenceManagersBinding() {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().contributionType(ContributionType.UNIQUE)).key(this.keyFactory.forSetOfReleasableReferenceManagers())).kind(BindingKind.RELEASABLE_REFERENCE_MANAGERS)).build();
    }

    ProvisionBinding setOfTypedReleasableReferenceManagersBinding(DeclaredType metadataType) {
        return (ProvisionBinding)((ProvisionBinding.Builder)this.setOfReleasableReferenceManagersBinding().toBuilder().key(this.keyFactory.forSetOfTypedReleasableReferenceManagers(metadataType))).build();
    }

    ContributionBinding syntheticOptionalBinding(Key key, RequestKind requestKind, ResolvedBindings underlyingKeyBindings) {
        Object builder = ((ContributionBinding.Builder)((ContributionBinding.Builder)this.syntheticOptionalBindingBuilder(requestKind, underlyingKeyBindings).contributionType(ContributionType.UNIQUE)).key(key)).kind(BindingKind.OPTIONAL);
        if (!underlyingKeyBindings.isEmpty()) {
            ((ContributionBinding.Builder)builder).dependencies(this.dependencyRequestFactory.forSyntheticPresentOptionalBinding(key, requestKind));
        }
        return ((ContributionBinding.Builder)builder).build();
    }

    private ContributionBinding.Builder<?, ?> syntheticOptionalBindingBuilder(RequestKind requestKind, ResolvedBindings underlyingKeyBindings) {
        return !underlyingKeyBindings.isEmpty() && (underlyingKeyBindings.bindingTypes().contains((Object)BindingType.PRODUCTION) || requestKind.equals((Object)RequestKind.PRODUCER) || requestKind.equals((Object)RequestKind.PRODUCED)) ? ProductionBinding.builder() : ProvisionBinding.builder();
    }

    ProvisionBinding membersInjectorBinding(Key key, MembersInjectionBinding membersInjectionBinding) {
        return (ProvisionBinding)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)((ProvisionBinding.Builder)ProvisionBinding.builder().key(key)).contributionType(ContributionType.UNIQUE)).kind(BindingKind.MEMBERS_INJECTOR)).bindingElement(MoreTypes.asTypeElement(membersInjectionBinding.key().type()))).provisionDependencies((Iterable<DependencyRequest>)membersInjectionBinding.dependencies()).injectionSites(membersInjectionBinding.injectionSites()).build();
    }

    MembersInjectionBinding membersInjectionBinding(DeclaredType declaredType, Optional<TypeMirror> resolvedType) {
        TypeElement typeElement;
        if (!declaredType.getTypeArguments().isEmpty() && resolvedType.isPresent()) {
            DeclaredType resolved = MoreTypes.asDeclared(resolvedType.get());
            Preconditions.checkState((boolean)this.types.isSameType(this.types.erasure(resolved), this.types.erasure(declaredType)), (String)"erased expected type: %s, erased actual type: %s", (Object)this.types.erasure(resolved), (Object)this.types.erasure(declaredType));
            declaredType = resolved;
        }
        ImmutableSortedSet<MembersInjectionBinding.InjectionSite> injectionSites = this.getInjectionSites(declaredType);
        ImmutableSet dependencies = injectionSites.stream().flatMap(injectionSite -> injectionSite.dependencies().stream()).collect(DaggerStreams.toImmutableSet());
        Key key = this.keyFactory.forMembersInjectedType(declaredType);
        return new AutoValue_MembersInjectionBinding(key, dependencies, typeElement, Binding.hasNonDefaultTypeParameters(typeElement = MoreElements.asType(declaredType.asElement()), key.type(), this.types) ? Optional.of(this.membersInjectionBinding(MoreTypes.asDeclared(typeElement.asType()), Optional.empty())) : Optional.empty(), injectionSites);
    }

    private ImmutableSortedSet<MembersInjectionBinding.InjectionSite> getInjectionSites(DeclaredType declaredType) {
        HashSet<MembersInjectionBinding.InjectionSite> injectionSites = new HashSet<MembersInjectionBinding.InjectionSite>();
        ArrayList<TypeElement> ancestors = new ArrayList<TypeElement>();
        LinkedHashMultimap overriddenMethodMap = LinkedHashMultimap.create();
        Optional<DeclaredType> currentType = Optional.of(declaredType);
        while (currentType.isPresent()) {
            DeclaredType type = currentType.get();
            ancestors.add(MoreElements.asType(type.asElement()));
            for (Element element : type.asElement().getEnclosedElements()) {
                Optional<MembersInjectionBinding.InjectionSite> maybeInjectionSite = this.injectionSiteVisitor.visit(element, type);
                if (!maybeInjectionSite.isPresent()) continue;
                MembersInjectionBinding.InjectionSite injectionSite2 = maybeInjectionSite.get();
                if (this.shouldBeInjected(injectionSite2.element(), (SetMultimap<String, ExecutableElement>)overriddenMethodMap)) {
                    injectionSites.add(injectionSite2);
                }
                if (!injectionSite2.kind().equals((Object)MembersInjectionBinding.InjectionSite.Kind.METHOD)) continue;
                ExecutableElement injectionSiteMethod = MoreElements.asExecutable(injectionSite2.element());
                overriddenMethodMap.put((Object)injectionSiteMethod.getSimpleName().toString(), (Object)injectionSiteMethod);
            }
            currentType = this.types.nonObjectSuperclass(currentType.get());
        }
        return ImmutableSortedSet.copyOf(Comparator.comparing(injectionSite -> ancestors.indexOf(injectionSite.element().getEnclosingElement())).reversed().thenComparing(injectionSite -> injectionSite.element().getKind()).thenComparing(MembersInjectionBinding.InjectionSite::indexAmongSiblingMembers), injectionSites);
    }

    private boolean shouldBeInjected(Element injectionSite, SetMultimap<String, ExecutableElement> overriddenMethodMap) {
        if (!MoreElements.isAnnotationPresent(injectionSite, Inject.class) || injectionSite.getModifiers().contains((Object)Modifier.PRIVATE) || injectionSite.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        if (injectionSite.getKind().isField()) {
            return true;
        }
        ExecutableElement injectionSiteMethod = MoreElements.asExecutable(injectionSite);
        TypeElement injectionSiteType = MoreElements.asType(injectionSite.getEnclosingElement());
        for (ExecutableElement method : overriddenMethodMap.get((Object)injectionSiteMethod.getSimpleName().toString())) {
            if (!this.elements.overrides(method, injectionSiteMethod, injectionSiteType)) continue;
            return false;
        }
        return true;
    }

    private MembersInjectionBinding.InjectionSite injectionSiteForInjectMethod(ExecutableElement methodElement, DeclaredType containingType) {
        Preconditions.checkNotNull((Object)methodElement);
        Preconditions.checkArgument((boolean)methodElement.getKind().equals((Object)ElementKind.METHOD));
        ExecutableType resolved = MoreTypes.asExecutable(this.types.asMemberOf(containingType, methodElement));
        return new AutoValue_MembersInjectionBinding_InjectionSite(MembersInjectionBinding.InjectionSite.Kind.METHOD, methodElement, this.dependencyRequestFactory.forRequiredResolvedVariables(methodElement.getParameters(), resolved.getParameterTypes()));
    }

    private MembersInjectionBinding.InjectionSite injectionSiteForInjectField(VariableElement fieldElement, DeclaredType containingType) {
        Preconditions.checkNotNull((Object)fieldElement);
        Preconditions.checkArgument((boolean)fieldElement.getKind().equals((Object)ElementKind.FIELD));
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent(fieldElement, Inject.class));
        TypeMirror resolved = this.types.asMemberOf(containingType, fieldElement);
        return new AutoValue_MembersInjectionBinding_InjectionSite(MembersInjectionBinding.InjectionSite.Kind.FIELD, fieldElement, (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)this.dependencyRequestFactory.forRequiredResolvedVariable(fieldElement, resolved)));
    }
}

