/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.BindingExpression;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.Expression;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.SwitchingProviders;
import dagger.model.Key;
import dagger.model.RequestKind;
import javax.inject.Provider;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class InnerSwitchingProviders
extends SwitchingProviders {
    private final ComponentBindingExpressions componentBindingExpressions;
    private final DaggerTypes types;

    InnerSwitchingProviders(GeneratedComponentModel generatedComponentModel, ComponentBindingExpressions componentBindingExpressions, DaggerTypes types) {
        super(generatedComponentModel, types);
        this.componentBindingExpressions = componentBindingExpressions;
        this.types = types;
    }

    BindingExpression newBindingExpression(final ContributionBinding binding) {
        return new BindingExpression(){

            @Override
            Expression getDependencyExpression(ClassName requestingClass) {
                return InnerSwitchingProviders.this.getProviderExpression(new SwitchCase(binding, requestingClass));
            }
        };
    }

    @Override
    protected TypeSpec createSwitchingProviderType(TypeSpec.Builder builder) {
        return builder.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addField(TypeName.INT, "id", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter(TypeName.INT, "id", new Modifier[0]).addStatement("this.id = id", new Object[0]).build()).build();
    }

    private final class SwitchCase
    implements SwitchingProviders.SwitchCase {
        private final ContributionBinding binding;
        private final ClassName requestingClass;

        SwitchCase(ContributionBinding binding, ClassName requestingClass) {
            this.binding = binding;
            this.requestingClass = requestingClass;
        }

        @Override
        public Key key() {
            return this.binding.key();
        }

        @Override
        public Expression getProviderExpression(ClassName switchType, int switchId) {
            TypeMirror instanceType = InnerSwitchingProviders.this.types.accessibleType(this.binding.contributedType(), this.requestingClass);
            return Expression.create(InnerSwitchingProviders.this.types.wrapType(instanceType, Provider.class), CodeBlock.of((String)"new $T<>($L)", (Object[])new Object[]{switchType, switchId}));
        }

        @Override
        public Expression getReturnExpression() {
            return InnerSwitchingProviders.this.componentBindingExpressions.getDependencyExpression(this.binding.key(), RequestKind.INSTANCE, this.requestingClass);
        }
    }
}

