/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import dagger.Binds;
import dagger.BindsOptionalOf;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.AutoValue_ModuleDescriptor;
import dagger.internal.codegen.BindingFactory;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.OptionalBindingDeclaration;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.SubcomponentDeclaration;
import dagger.multibindings.Multibinds;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

abstract class ModuleDescriptor {
    ModuleDescriptor() {
    }

    abstract TypeElement moduleElement();

    abstract ImmutableSet<TypeElement> includedModules();

    abstract ImmutableSet<ContributionBinding> bindings();

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    abstract ImmutableSet<DelegateDeclaration> delegateDeclarations();

    abstract ImmutableSet<OptionalBindingDeclaration> optionalDeclarations();

    abstract Kind kind();

    static final class Factory {
        private final DaggerElements elements;
        private final BindingFactory bindingFactory;
        private final MultibindingDeclaration.Factory multibindingDeclarationFactory;
        private final DelegateDeclaration.Factory bindingDelegateDeclarationFactory;
        private final SubcomponentDeclaration.Factory subcomponentDeclarationFactory;
        private final OptionalBindingDeclaration.Factory optionalBindingDeclarationFactory;

        @Inject
        Factory(DaggerElements elements, BindingFactory bindingFactory, MultibindingDeclaration.Factory multibindingDeclarationFactory, DelegateDeclaration.Factory bindingDelegateDeclarationFactory, SubcomponentDeclaration.Factory subcomponentDeclarationFactory, OptionalBindingDeclaration.Factory optionalBindingDeclarationFactory) {
            this.elements = elements;
            this.bindingFactory = bindingFactory;
            this.multibindingDeclarationFactory = multibindingDeclarationFactory;
            this.bindingDelegateDeclarationFactory = bindingDelegateDeclarationFactory;
            this.subcomponentDeclarationFactory = subcomponentDeclarationFactory;
            this.optionalBindingDeclarationFactory = optionalBindingDeclarationFactory;
        }

        ModuleDescriptor create(TypeElement moduleElement) {
            ImmutableSet.Builder bindings = ImmutableSet.builder();
            ImmutableSet.Builder delegates = ImmutableSet.builder();
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            ImmutableSet.Builder optionalDeclarations = ImmutableSet.builder();
            for (ExecutableElement moduleMethod : ElementFilter.methodsIn(this.elements.getAllMembers(moduleElement))) {
                if (MoreElements.isAnnotationPresent(moduleMethod, Provides.class)) {
                    bindings.add((Object)this.bindingFactory.providesMethodBinding(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Produces.class)) {
                    bindings.add((Object)this.bindingFactory.producesMethodBinding(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Binds.class)) {
                    delegates.add((Object)this.bindingDelegateDeclarationFactory.create(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Multibinds.class)) {
                    multibindingDeclarations.add((Object)this.multibindingDeclarationFactory.forMultibindsMethod(moduleMethod, moduleElement));
                }
                if (!MoreElements.isAnnotationPresent(moduleMethod, BindsOptionalOf.class)) continue;
                optionalDeclarations.add((Object)this.optionalBindingDeclarationFactory.forMethod(moduleMethod, moduleElement));
            }
            return new AutoValue_ModuleDescriptor(moduleElement, (ImmutableSet<TypeElement>)ImmutableSet.copyOf(this.collectIncludedModules(new LinkedHashSet<TypeElement>(), moduleElement)), (ImmutableSet<ContributionBinding>)bindings.build(), (ImmutableSet<MultibindingDeclaration>)multibindingDeclarations.build(), this.subcomponentDeclarationFactory.forModule(moduleElement), (ImmutableSet<DelegateDeclaration>)delegates.build(), (ImmutableSet<OptionalBindingDeclaration>)optionalDeclarations.build(), Kind.forAnnotatedElement(moduleElement).get());
        }

        @CanIgnoreReturnValue
        private Set<TypeElement> collectIncludedModules(Set<TypeElement> includedModules, TypeElement moduleElement) {
            Optional<AnnotationMirror> moduleAnnotation;
            TypeMirror superclass = moduleElement.getSuperclass();
            if (!superclass.getKind().equals((Object)TypeKind.NONE)) {
                Verify.verify((boolean)superclass.getKind().equals((Object)TypeKind.DECLARED));
                TypeElement superclassElement = MoreTypes.asTypeElement(superclass);
                if (!superclassElement.getQualifiedName().contentEquals(Object.class.getCanonicalName())) {
                    this.collectIncludedModules(includedModules, superclassElement);
                }
            }
            if ((moduleAnnotation = ConfigurationAnnotations.getModuleAnnotation(moduleElement)).isPresent()) {
                includedModules.addAll((Collection<TypeElement>)MoreTypes.asTypeElements(ConfigurationAnnotations.getModuleIncludes(moduleAnnotation.get())));
                includedModules.addAll((Collection<TypeElement>)this.implicitlyIncludedModules(moduleElement));
            }
            return includedModules;
        }

        private ImmutableSet<TypeElement> implicitlyIncludedModules(TypeElement moduleElement) {
            TypeElement contributesAndroidInjector = this.elements.getTypeElement("dagger.android.ContributesAndroidInjector");
            if (contributesAndroidInjector == null) {
                return ImmutableSet.of();
            }
            return ElementFilter.methodsIn(moduleElement.getEnclosedElements()).stream().filter(method -> DaggerElements.isAnnotationPresent(method, contributesAndroidInjector.asType())).map(method -> this.elements.checkTypePresent(this.implicitlyIncludedModuleName((ExecutableElement)method))).collect(DaggerStreams.toImmutableSet());
        }

        private String implicitlyIncludedModuleName(ExecutableElement method) {
            return MoreElements.getPackage(method).getQualifiedName() + "." + SourceFiles.classFileName(ClassName.get((TypeElement)MoreElements.asType(method.getEnclosingElement()))) + "_" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, method.getSimpleName().toString());
        }
    }

    static enum Kind {
        MODULE(Module.class, Provides.class),
        PRODUCER_MODULE(ProducerModule.class, Produces.class);

        private final Class<? extends Annotation> moduleAnnotation;
        private final Class<? extends Annotation> methodAnnotation;

        static Optional<Kind> forAnnotatedElement(TypeElement element) {
            EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
            for (Kind kind : Kind.values()) {
                if (!MoreElements.isAnnotationPresent(element, kind.moduleAnnotation())) continue;
                kinds.add(kind);
            }
            Preconditions.checkArgument((kinds.size() <= 1 ? 1 : 0) != 0, (String)"%s cannot be annotated with more than one of %s", (Object)element, kinds);
            return kinds.stream().findFirst();
        }

        private Kind(Class<? extends Annotation> moduleAnnotation, Class<? extends Annotation> methodAnnotation) {
            this.moduleAnnotation = moduleAnnotation;
            this.methodAnnotation = methodAnnotation;
        }

        Optional<AnnotationMirror> getModuleAnnotationMirror(TypeElement element) {
            return DaggerElements.getAnnotationMirror(element, this.moduleAnnotation);
        }

        Class<? extends Annotation> moduleAnnotation() {
            return this.moduleAnnotation;
        }

        Class<? extends Annotation> methodAnnotation() {
            return this.methodAnnotation;
        }

        ImmutableSet<Kind> includesKinds() {
            switch (this) {
                case MODULE: {
                    return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new Kind[0]);
                }
                case PRODUCER_MODULE: {
                    return Sets.immutableEnumSet((Enum)MODULE, (Enum[])new Kind[]{PRODUCER_MODULE});
                }
            }
            throw new AssertionError((Object)this);
        }
    }
}

