/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindingFactory;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.InaccessibleMapKeyProxyGenerator;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ProducerFactoryGenerator;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ModuleProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final ModuleValidator moduleValidator;
    private final BindingFactory bindingFactory;
    private final FactoryGenerator factoryGenerator;
    private final ProducerFactoryGenerator producerFactoryGenerator;
    private final InaccessibleMapKeyProxyGenerator inaccessibleMapKeyProxyGenerator;
    private final DelegateDeclaration.Factory delegateDeclarationFactory;
    private final Set<TypeElement> processedModuleElements = Sets.newLinkedHashSet();

    @Inject
    ModuleProcessingStep(Messager messager, ModuleValidator moduleValidator, BindingFactory bindingFactory, FactoryGenerator factoryGenerator, ProducerFactoryGenerator producerFactoryGenerator, InaccessibleMapKeyProxyGenerator inaccessibleMapKeyProxyGenerator, DelegateDeclaration.Factory delegateDeclarationFactory) {
        this.messager = messager;
        this.moduleValidator = moduleValidator;
        this.bindingFactory = bindingFactory;
        this.factoryGenerator = factoryGenerator;
        this.producerFactoryGenerator = producerFactoryGenerator;
        this.inaccessibleMapKeyProxyGenerator = inaccessibleMapKeyProxyGenerator;
        this.delegateDeclarationFactory = delegateDeclarationFactory;
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Module.class, ProducerModule.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        List<TypeElement> modules = ElementFilter.typesIn(elementsByAnnotation.values());
        this.moduleValidator.addKnownModules(modules);
        for (TypeElement module : modules) {
            if (!this.processedModuleElements.add(module)) continue;
            this.processModule(module);
        }
        return ImmutableSet.of();
    }

    private void processModule(TypeElement module) {
        ValidationReport<TypeElement> report = this.moduleValidator.validate(module);
        report.printMessagesTo(this.messager);
        if (report.isClean()) {
            for (ExecutableElement method : ElementFilter.methodsIn(module.getEnclosedElements())) {
                if (MoreElements.isAnnotationPresent(method, Provides.class)) {
                    this.generate(this.factoryGenerator, this.bindingFactory.providesMethodBinding(method, module));
                    continue;
                }
                if (MoreElements.isAnnotationPresent(method, Produces.class)) {
                    this.generate(this.producerFactoryGenerator, this.bindingFactory.producesMethodBinding(method, module));
                    continue;
                }
                if (!MoreElements.isAnnotationPresent(method, Binds.class)) continue;
                this.inaccessibleMapKeyProxyGenerator.generate(this.bindsMethodBinding(module, method), this.messager);
            }
        }
    }

    private <B extends ContributionBinding> void generate(SourceFileGenerator<B> generator, B binding) {
        generator.generate(binding, this.messager);
        this.inaccessibleMapKeyProxyGenerator.generate(binding, this.messager);
    }

    private ContributionBinding bindsMethodBinding(TypeElement module, ExecutableElement method) {
        return this.bindingFactory.unresolvedDelegateBinding(this.delegateDeclarationFactory.create(method, module));
    }
}

