/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import dagger.MapKey;
import dagger.internal.codegen.base.MapKeyAccessibility;
import dagger.internal.codegen.binding.AnnotationExpression;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;

public final class MapKeys {
    static Optional<AnnotationMirror> getMapKey(Element bindingElement) {
        ImmutableSet<? extends AnnotationMirror> mapKeys = MapKeys.getMapKeys(bindingElement);
        return mapKeys.isEmpty() ? Optional.empty() : Optional.of((AnnotationMirror)Iterables.getOnlyElement(mapKeys));
    }

    public static ImmutableSet<? extends AnnotationMirror> getMapKeys(Element bindingElement) {
        return AnnotationMirrors.getAnnotatedAnnotations(bindingElement, MapKey.class);
    }

    static Optional<? extends AnnotationValue> unwrapValue(AnnotationMirror mapKey) {
        MapKey mapKeyAnnotation = mapKey.getAnnotationType().asElement().getAnnotation(MapKey.class);
        Preconditions.checkArgument((mapKeyAnnotation != null ? 1 : 0) != 0, (String)"%s is not annotated with @MapKey", (Object)mapKey.getAnnotationType());
        return mapKeyAnnotation.unwrapValue() ? Optional.of((AnnotationValue)Iterables.getOnlyElement((Iterable)AnnotationMirrors.getAnnotationValuesWithDefaults(mapKey).values())) : Optional.empty();
    }

    static TypeMirror mapKeyType(AnnotationMirror mapKeyAnnotation, DaggerTypes types) {
        return MapKeys.unwrapValue(mapKeyAnnotation).isPresent() ? MapKeys.getUnwrappedMapKeyType(mapKeyAnnotation.getAnnotationType(), types) : mapKeyAnnotation.getAnnotationType();
    }

    public static DeclaredType getUnwrappedMapKeyType(final DeclaredType mapKeyAnnotationType, final DaggerTypes types) {
        Preconditions.checkArgument((MoreTypes.asTypeElement(mapKeyAnnotationType).getKind() == ElementKind.ANNOTATION_TYPE ? 1 : 0) != 0, (String)"%s is not an annotation type", (Object)mapKeyAnnotationType);
        final ExecutableElement onlyElement = (ExecutableElement)Iterables.getOnlyElement(ElementFilter.methodsIn(mapKeyAnnotationType.asElement().getEnclosedElements()));
        SimpleTypeVisitor6<DeclaredType, Void> keyTypeElementVisitor = new SimpleTypeVisitor6<DeclaredType, Void>(){

            @Override
            public DeclaredType visitArray(ArrayType t, Void p) {
                throw new IllegalArgumentException(mapKeyAnnotationType + "." + onlyElement.getSimpleName() + " cannot be an array");
            }

            @Override
            public DeclaredType visitPrimitive(PrimitiveType t, Void p) {
                return MoreTypes.asDeclared(types.boxedClass(t).asType());
            }

            @Override
            public DeclaredType visitDeclared(DeclaredType t, Void p) {
                return t;
            }
        };
        return (DeclaredType)keyTypeElementVisitor.visit(onlyElement.getReturnType());
    }

    public static CodeBlock getMapKeyExpression(ContributionBinding binding, ClassName requestingClass, DaggerElements elements) {
        AnnotationMirror mapKeyAnnotation = binding.mapKeyAnnotation().get();
        return MapKeyAccessibility.isMapKeyAccessibleFrom(mapKeyAnnotation, requestingClass.packageName()) ? MapKeys.directMapKeyExpression(mapKeyAnnotation, elements) : CodeBlock.of((String)"$T.create()", (Object[])new Object[]{MapKeys.mapKeyProxyClassName(binding)});
    }

    private static CodeBlock directMapKeyExpression(AnnotationMirror mapKey, DaggerElements elements) {
        Optional<? extends AnnotationValue> unwrappedValue = MapKeys.unwrapValue(mapKey);
        AnnotationExpression annotationExpression = new AnnotationExpression(mapKey);
        if (MoreTypes.asTypeElement(mapKey.getAnnotationType()).getQualifiedName().contentEquals("dagger.android.AndroidInjectionKey")) {
            TypeElement unwrappedType = elements.checkTypePresent((String)unwrappedValue.get().getValue());
            return CodeBlock.of((String)"$T.of($S)", (Object[])new Object[]{ClassName.get((String)"dagger.android.internal", (String)"AndroidInjectionKeys", (String[])new String[0]), ClassName.get((TypeElement)unwrappedType).reflectionName()});
        }
        if (unwrappedValue.isPresent()) {
            TypeMirror unwrappedValueType = ((ExecutableElement)Iterables.getOnlyElement((Iterable)AnnotationMirrors.getAnnotationValuesWithDefaults(mapKey).keySet())).getReturnType();
            return annotationExpression.getValueExpression(unwrappedValueType, unwrappedValue.get());
        }
        return annotationExpression.getAnnotationInstanceExpression();
    }

    public static ClassName mapKeyProxyClassName(ContributionBinding binding) {
        return SourceFiles.elementBasedClassName(MoreElements.asExecutable(binding.bindingElement().get()), "MapKey");
    }

    public static Optional<MethodSpec> mapKeyFactoryMethod(ContributionBinding binding, DaggerTypes types, DaggerElements elements) {
        return binding.mapKeyAnnotation().filter(mapKey -> !MapKeyAccessibility.isMapKeyPubliclyAccessible(mapKey)).map(mapKey -> MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(TypeName.get((TypeMirror)MapKeys.mapKeyType(mapKey, types))).addStatement("return $L", new Object[]{MapKeys.directMapKeyExpression(mapKey, elements)}).build());
    }

    private MapKeys() {
    }
}

