/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableSet;
import dagger.Binds;
import dagger.Module;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.BindsTypeChecker;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.BindingElementValidator;
import dagger.internal.codegen.validation.BindingMethodValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.TypeHierarchyValidator;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class BindsMethodValidator
extends BindingMethodValidator {
    private final DaggerTypes types;
    private final BindsTypeChecker bindsTypeChecker;

    @Inject
    BindsMethodValidator(DaggerElements elements, DaggerTypes types, KotlinMetadataUtil kotlinMetadataUtil, BindsTypeChecker bindsTypeChecker, DependencyRequestValidator dependencyRequestValidator, InjectionAnnotations injectionAnnotations) {
        super(elements, types, kotlinMetadataUtil, Binds.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), dependencyRequestValidator, BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.NO_EXCEPTIONS, BindingElementValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS, BindingElementValidator.AllowsScoping.ALLOWS_SCOPING, injectionAnnotations);
        this.types = types;
        this.bindsTypeChecker = bindsTypeChecker;
    }

    @Override
    protected BindingElementValidator.ElementValidator elementValidator(ExecutableElement element) {
        return new Validator(element);
    }

    private class Validator
    extends BindingMethodValidator.MethodValidator {
        Validator(ExecutableElement element) {
            super(BindsMethodValidator.this, element);
        }

        @Override
        protected void checkParameters() {
            if (((ExecutableElement)this.element).getParameters().size() != 1) {
                this.report.addError(BindsMethodValidator.this.bindingMethods("must have exactly one parameter, whose type is assignable to the return type", new Object[0]));
            } else {
                super.checkParameters();
            }
        }

        @Override
        protected void checkParameter(VariableElement parameter) {
            super.checkParameter(parameter);
            TypeMirror leftHandSide = this.boxIfNecessary(((ExecutableElement)this.element).getReturnType());
            TypeMirror rightHandSide = parameter.asType();
            ContributionType contributionType = ContributionType.fromBindingElement(this.element);
            if (contributionType.equals((Object)ContributionType.SET_VALUES) && !SetType.isSet(leftHandSide)) {
                this.report.addError("@Binds @ElementsIntoSet methods must return a Set and take a Set parameter");
            }
            if (!BindsMethodValidator.this.bindsTypeChecker.isAssignable(rightHandSide, leftHandSide, contributionType)) {
                TypeHierarchyValidator.validateTypeHierarchy(leftHandSide, BindsMethodValidator.this.types);
                TypeHierarchyValidator.validateTypeHierarchy(rightHandSide, BindsMethodValidator.this.types);
                this.report.addError("@Binds methods' parameter type must be assignable to the return type");
            }
        }

        private TypeMirror boxIfNecessary(TypeMirror maybePrimitive) {
            if (maybePrimitive.getKind().isPrimitive()) {
                return BindsMethodValidator.this.types.boxedClass(MoreTypes.asPrimitiveType(maybePrimitive)).asType();
            }
            return maybePrimitive;
        }
    }
}

