/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Reusable;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.ComponentCreatorAnnotation;
import dagger.internal.codegen.binding.ComponentKind;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.ErrorMessages;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.binding.ModuleKind;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.langmodel.DaggerTypes;
import dagger.internal.codegen.validation.ComponentCreatorValidator;
import dagger.internal.codegen.validation.DependencyRequestValidator;
import dagger.internal.codegen.validation.MembersInjectionValidator;
import dagger.internal.codegen.validation.ModuleValidator;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.producers.CancellationPolicy;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor8;

@Singleton
public final class ComponentValidator
implements ClearableCache {
    private final DaggerElements elements;
    private final DaggerTypes types;
    private final ModuleValidator moduleValidator;
    private final ComponentCreatorValidator creatorValidator;
    private final DependencyRequestValidator dependencyRequestValidator;
    private final MembersInjectionValidator membersInjectionValidator;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final DependencyRequestFactory dependencyRequestFactory;
    private final Map<TypeElement, ValidationReport<TypeElement>> reports = new HashMap<TypeElement, ValidationReport<TypeElement>>();
    private static final TypeVisitor<Void, ValidationReport.Builder<?>> CHECK_DEPENDENCY_TYPES = new SimpleTypeVisitor8<Void, ValidationReport.Builder<?>>(){

        @Override
        protected Void defaultAction(TypeMirror type, ValidationReport.Builder<?> report) {
            report.addError(type + " is not a valid component dependency type");
            return null;
        }

        @Override
        public Void visitDeclared(DeclaredType type, ValidationReport.Builder<?> report) {
            if (ModuleAnnotation.moduleAnnotation(MoreTypes.asTypeElement(type)).isPresent()) {
                report.addError(type + " is a module, which cannot be a component dependency");
            }
            return null;
        }
    };

    @Inject
    ComponentValidator(DaggerElements elements, DaggerTypes types, ModuleValidator moduleValidator, ComponentCreatorValidator creatorValidator, DependencyRequestValidator dependencyRequestValidator, MembersInjectionValidator membersInjectionValidator, MethodSignatureFormatter methodSignatureFormatter, DependencyRequestFactory dependencyRequestFactory) {
        this.elements = elements;
        this.types = types;
        this.moduleValidator = moduleValidator;
        this.creatorValidator = creatorValidator;
        this.dependencyRequestValidator = dependencyRequestValidator;
        this.membersInjectionValidator = membersInjectionValidator;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.dependencyRequestFactory = dependencyRequestFactory;
    }

    @Override
    public void clearCache() {
        this.reports.clear();
    }

    public ValidationReport<TypeElement> validate(TypeElement component) {
        return Util.reentrantComputeIfAbsent(this.reports, component, this::validateUncached);
    }

    private ValidationReport<TypeElement> validateUncached(TypeElement component) {
        return new ElementValidator(component).validateElement();
    }

    private static boolean isEntryPoint(ExecutableElement method, ExecutableType methodType) {
        return method.getModifiers().contains((Object)Modifier.ABSTRACT) && method.getParameters().isEmpty() && !methodType.getReturnType().getKind().equals((Object)TypeKind.VOID) && methodType.getTypeVariables().isEmpty();
    }

    private void addMethodUnlessOverridden(ExecutableElement method, Set<ExecutableElement> methods) {
        if (methods.stream().noneMatch(existingMethod -> this.overridesAsDeclared((ExecutableElement)existingMethod, method))) {
            methods.removeIf(existingMethod -> this.overridesAsDeclared(method, (ExecutableElement)existingMethod));
            methods.add(method);
        }
    }

    private boolean overridesAsDeclared(ExecutableElement overrider, ExecutableElement overridden) {
        return this.elements.overrides(overrider, overridden, MoreElements.asType(overrider.getEnclosingElement()));
    }

    private static Optional<AnnotationMirror> checkForAnnotations(TypeMirror type, final Set<? extends Class<? extends Annotation>> annotations) {
        return type.accept(new SimpleTypeVisitor8<Optional<AnnotationMirror>, Void>(Optional.empty()){

            @Override
            public Optional<AnnotationMirror> visitDeclared(DeclaredType t, Void p) {
                return DaggerElements.getAnyAnnotation(t.asElement(), annotations);
            }
        }, null);
    }

    private class ElementValidator {
        private final TypeElement component;
        private final ValidationReport.Builder<TypeElement> report;
        private final ImmutableSet<ComponentKind> componentKinds;
        private final SetMultimap<Element, ExecutableElement> referencedSubcomponents = LinkedHashMultimap.create();

        ElementValidator(TypeElement component) {
            this.component = component;
            this.report = ValidationReport.about(component);
            this.componentKinds = ComponentKind.getComponentKinds(component);
        }

        private ComponentKind componentKind() {
            return (ComponentKind)((Object)Iterables.getOnlyElement(this.componentKinds));
        }

        private ComponentAnnotation componentAnnotation() {
            return ComponentAnnotation.anyComponentAnnotation(this.component).get();
        }

        private DeclaredType componentType() {
            return MoreTypes.asDeclared(this.component.asType());
        }

        ValidationReport<TypeElement> validateElement() {
            if (this.componentKinds.size() > 1) {
                return this.moreThanOneComponentAnnotation();
            }
            this.validateUseOfCancellationPolicy();
            this.validateIsAbstractType();
            this.validateCreators();
            this.validateNoReusableAnnotation();
            this.validateComponentMethods();
            this.validateNoConflictingEntryPoints();
            this.validateSubcomponentReferences();
            this.validateComponentDependencies();
            this.validateReferencedModules();
            this.validateSubcomponents();
            return this.report.build();
        }

        private ValidationReport<TypeElement> moreThanOneComponentAnnotation() {
            String error = "Components may not be annotated with more than one component annotation: found " + ComponentKind.annotationsFor(this.componentKinds);
            this.report.addError(error, this.component);
            return this.report.build();
        }

        private void validateUseOfCancellationPolicy() {
            if (MoreElements.isAnnotationPresent(this.component, CancellationPolicy.class) && !this.componentKind().isProducer()) {
                this.report.addError("@CancellationPolicy may only be applied to production components and subcomponents", this.component);
            }
        }

        private void validateIsAbstractType() {
            if (!(this.component.getKind().equals((Object)ElementKind.INTERFACE) || this.component.getKind().equals((Object)ElementKind.CLASS) && this.component.getModifiers().contains((Object)Modifier.ABSTRACT))) {
                this.report.addError(String.format("@%s may only be applied to an interface or abstract class", this.componentKind().annotation().getSimpleName()), this.component);
            }
        }

        private void validateCreators() {
            ImmutableList creators = (ImmutableList)ComponentCreatorAnnotation.creatorAnnotationsFor(this.componentAnnotation()).stream().flatMap(annotation -> ConfigurationAnnotations.enclosedAnnotatedTypes(this.component, annotation).stream()).collect(DaggerStreams.toImmutableList());
            creators.forEach(creator -> this.report.addSubreport(ComponentValidator.this.creatorValidator.validate(MoreTypes.asTypeElement(creator))));
            if (creators.size() > 1) {
                this.report.addError(String.format(ErrorMessages.componentMessagesFor(this.componentKind()).moreThanOne(), creators), this.component);
            }
        }

        private void validateNoReusableAnnotation() {
            Optional<AnnotationMirror> reusableAnnotation = DaggerElements.getAnnotationMirror(this.component, Reusable.class);
            if (reusableAnnotation.isPresent()) {
                this.report.addError("@Reusable cannot be applied to components or subcomponents", this.component, reusableAnnotation.get());
            }
        }

        private void validateComponentMethods() {
            MoreElements.getLocalAndInheritedMethods(this.component, ComponentValidator.this.types, ComponentValidator.this.elements).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).map(x$0 -> new ComponentMethodValidator((ExecutableElement)x$0)).forEachOrdered(ComponentMethodValidator::validateMethod);
        }

        private void validateNoConflictingEntryPoints() {
            HashMultimap entryPointMethods = HashMultimap.create();
            ElementFilter.methodsIn(ComponentValidator.this.elements.getAllMembers(this.component)).stream().filter(method -> ComponentValidator.isEntryPoint(method, MoreTypes.asExecutable(ComponentValidator.this.types.asMemberOf(this.componentType(), (Element)method)))).forEach(arg_0 -> this.lambda$validateNoConflictingEntryPoints$5((SetMultimap)entryPointMethods, arg_0));
            for (Set methods : Multimaps.asMap((SetMultimap)entryPointMethods).values()) {
                if (this.distinctKeys(methods).size() <= 1) continue;
                this.reportConflictingEntryPoints(methods);
            }
        }

        private void reportConflictingEntryPoints(Collection<ExecutableElement> methods) {
            Verify.verify((methods.stream().map(Element::getEnclosingElement).distinct().count() == (long)methods.size() ? 1 : 0) != 0, (String)"expected each method to be declared on a different type: %s", methods);
            StringBuilder message = new StringBuilder("conflicting entry point declarations:");
            ComponentValidator.this.methodSignatureFormatter.typedFormatter(this.componentType()).formatIndentedList(message, (Iterable<ExecutableElement>)ImmutableList.sortedCopyOf(Comparator.comparing(method -> MoreElements.asType(method.getEnclosingElement()).getQualifiedName().toString()), methods), 1);
            this.report.addError(message.toString());
        }

        private void validateSubcomponentReferences() {
            Maps.filterValues((Map)this.referencedSubcomponents.asMap(), methods -> methods.size() > 1).forEach((subcomponent, methods) -> this.report.addError(String.format(ErrorMessages.ComponentCreatorMessages.moreThanOneRefToSubcomponent(), subcomponent, methods), this.component));
        }

        private void validateComponentDependencies() {
            for (TypeMirror type : this.componentAnnotation().dependencyTypes()) {
                type.accept(CHECK_DEPENDENCY_TYPES, this.report);
            }
        }

        private void validateReferencedModules() {
            this.report.addSubreport(ComponentValidator.this.moduleValidator.validateReferencedModules(this.component, this.componentAnnotation().annotation(), this.componentKind().legalModuleKinds(), new HashSet<TypeElement>()));
        }

        private void validateSubcomponents() {
            for (Element subcomponent : this.referencedSubcomponents.keySet()) {
                ValidationReport<TypeElement> subreport = ComponentValidator.this.validate(MoreElements.asType(subcomponent));
                this.report.addSubreport(subreport);
            }
        }

        private ImmutableSet<Key> distinctKeys(Set<ExecutableElement> methods) {
            return (ImmutableSet)methods.stream().map(this::dependencyRequest).map(DependencyRequest::key).collect(DaggerStreams.toImmutableSet());
        }

        private DependencyRequest dependencyRequest(ExecutableElement method) {
            ExecutableType methodType = MoreTypes.asExecutable(ComponentValidator.this.types.asMemberOf(this.componentType(), method));
            return ComponentKind.forAnnotatedElement(this.component).get().isProducer() ? ComponentValidator.this.dependencyRequestFactory.forComponentProductionMethod(method, methodType) : ComponentValidator.this.dependencyRequestFactory.forComponentProvisionMethod(method, methodType);
        }

        private /* synthetic */ void lambda$validateNoConflictingEntryPoints$5(SetMultimap entryPointMethods, ExecutableElement method) {
            ComponentValidator.this.addMethodUnlessOverridden(method, entryPointMethods.get((Object)method.getSimpleName().toString()));
        }

        private class ComponentMethodValidator {
            private final ExecutableElement method;
            private final ExecutableType resolvedMethod;
            private final List<? extends TypeMirror> parameterTypes;
            private final List<? extends VariableElement> parameters;
            private final TypeMirror returnType;

            ComponentMethodValidator(ExecutableElement method) {
                this.method = method;
                this.resolvedMethod = MoreTypes.asExecutable(ComponentValidator.this.types.asMemberOf(ElementValidator.this.componentType(), method));
                this.parameterTypes = this.resolvedMethod.getParameterTypes();
                this.parameters = method.getParameters();
                this.returnType = this.resolvedMethod.getReturnType();
            }

            void validateMethod() {
                this.validateNoTypeVariables();
                Optional<AnnotationMirror> subcomponentAnnotation = this.subcomponentAnnotation();
                if (subcomponentAnnotation.isPresent()) {
                    this.validateSubcomponentFactoryMethod(subcomponentAnnotation.get());
                } else if (this.subcomponentCreatorAnnotation().isPresent()) {
                    this.validateSubcomponentCreatorMethod();
                } else {
                    switch (this.parameters.size()) {
                        case 0: {
                            this.validateProvisionMethod();
                            break;
                        }
                        case 1: {
                            this.validateMembersInjectionMethod();
                            break;
                        }
                        default: {
                            this.reportInvalidMethod();
                        }
                    }
                }
            }

            private void validateNoTypeVariables() {
                if (!this.resolvedMethod.getTypeVariables().isEmpty()) {
                    ElementValidator.this.report.addError("Component methods cannot have type variables", this.method);
                }
            }

            private Optional<AnnotationMirror> subcomponentAnnotation() {
                return ComponentValidator.checkForAnnotations(this.returnType, (Set)ElementValidator.this.componentKind().legalSubcomponentKinds().stream().map(ComponentKind::annotation).collect(DaggerStreams.toImmutableSet()));
            }

            private Optional<AnnotationMirror> subcomponentCreatorAnnotation() {
                return ComponentValidator.checkForAnnotations(this.returnType, ElementValidator.this.componentAnnotation().isProduction() ? Sets.intersection(ComponentCreatorAnnotation.subcomponentCreatorAnnotations(), ComponentCreatorAnnotation.productionCreatorAnnotations()) : ComponentCreatorAnnotation.subcomponentCreatorAnnotations());
            }

            private void validateSubcomponentFactoryMethod(AnnotationMirror subcomponentAnnotation) {
                ElementValidator.this.referencedSubcomponents.put((Object)MoreTypes.asElement(this.returnType), (Object)this.method);
                final ComponentKind subcomponentKind = ComponentKind.forAnnotatedElement(MoreTypes.asTypeElement(this.returnType)).get();
                ImmutableSet<TypeElement> moduleTypes = ComponentAnnotation.componentAnnotation(subcomponentAnnotation).modules();
                ImmutableSet<TypeElement> transitiveModules = ConfigurationAnnotations.getTransitiveModules(ComponentValidator.this.types, ComponentValidator.this.elements, moduleTypes);
                HashSet variableTypes = Sets.newHashSet();
                for (int i = 0; i < this.parameterTypes.size(); ++i) {
                    VariableElement parameter = this.parameters.get(i);
                    TypeMirror parameterType = this.parameterTypes.get(i);
                    Optional<TypeElement> moduleType = parameterType.accept(new SimpleTypeVisitor8<Optional<TypeElement>, Void>(){

                        @Override
                        protected Optional<TypeElement> defaultAction(TypeMirror e, Void p) {
                            return Optional.empty();
                        }

                        @Override
                        public Optional<TypeElement> visitDeclared(DeclaredType t, Void p) {
                            for (ModuleKind moduleKind : subcomponentKind.legalModuleKinds()) {
                                if (!MoreElements.isAnnotationPresent(t.asElement(), moduleKind.annotation())) continue;
                                return Optional.of(MoreTypes.asTypeElement(t));
                            }
                            return Optional.empty();
                        }
                    }, null);
                    if (moduleType.isPresent()) {
                        if (variableTypes.contains(moduleType.get())) {
                            ElementValidator.this.report.addError(String.format("A module may only occur once an an argument in a Subcomponent factory method, but %s was already passed.", moduleType.get().getQualifiedName()), parameter);
                        }
                        if (!transitiveModules.contains((Object)moduleType.get())) {
                            ElementValidator.this.report.addError(String.format("%s is present as an argument to the %s factory method, but is not one of the modules used to implement the subcomponent.", moduleType.get().getQualifiedName(), MoreTypes.asTypeElement(this.returnType).getQualifiedName()), this.method);
                        }
                        variableTypes.add(moduleType.get());
                        continue;
                    }
                    ElementValidator.this.report.addError(String.format("Subcomponent factory methods may only accept modules, but %s is not.", parameterType), parameter);
                }
            }

            private void validateSubcomponentCreatorMethod() {
                ElementValidator.this.referencedSubcomponents.put((Object)MoreTypes.asElement(this.returnType).getEnclosingElement(), (Object)this.method);
                if (!this.parameters.isEmpty()) {
                    ElementValidator.this.report.addError(ErrorMessages.ComponentCreatorMessages.builderMethodRequiresNoArgs(), this.method);
                }
                TypeElement creatorElement = MoreTypes.asTypeElement(this.returnType);
                ElementValidator.this.report.addSubreport(ComponentValidator.this.creatorValidator.validate(creatorElement));
            }

            private void validateProvisionMethod() {
                ComponentValidator.this.dependencyRequestValidator.validateDependencyRequest(ElementValidator.this.report, this.method, this.returnType);
            }

            private void validateMembersInjectionMethod() {
                TypeMirror parameterType = (TypeMirror)Iterables.getOnlyElement(this.parameterTypes);
                ElementValidator.this.report.addSubreport(ComponentValidator.this.membersInjectionValidator.validateMembersInjectionMethod(this.method, parameterType));
                if (!this.returnType.getKind().equals((Object)TypeKind.VOID) && !ComponentValidator.this.types.isSameType(this.returnType, parameterType)) {
                    ElementValidator.this.report.addError("Members injection methods may only return the injected type or void.", this.method);
                }
            }

            private void reportInvalidMethod() {
                ElementValidator.this.report.addError("This method isn't a valid provision method, members injection method or subcomponent factory method. Dagger cannot implement this method", this.method);
            }
        }
    }
}

