/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentCreatorKind;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.javapoet.TypeSpecs;
import dagger.internal.codegen.langmodel.Accessibility;
import dagger.internal.codegen.writing.SubcomponentNames;
import dagger.model.Key;
import dagger.model.RequestKind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public final class ComponentImplementation {
    private ComponentImplementation currentShard = this;
    private final Map<Key, ComponentImplementation> shardsByKey = new HashMap<Key, ComponentImplementation>();
    private final Optional<ComponentImplementation> shardOwner;
    private final BindingGraph graph;
    private final ClassName name;
    private final TypeSpec.Builder component;
    private final SubcomponentNames subcomponentNames;
    private final CompilerOptions compilerOptions;
    private final CodeBlock externalReferenceBlock;
    private final UniqueNameSet componentFieldNames = new UniqueNameSet();
    private final UniqueNameSet componentMethodNames = new UniqueNameSet();
    private final List<CodeBlock> initializations = new ArrayList<CodeBlock>();
    private final List<CodeBlock> componentRequirementInitializations = new ArrayList<CodeBlock>();
    private final Map<ComponentRequirement, String> componentRequirementParameterNames = new HashMap<ComponentRequirement, String>();
    private final Set<Key> cancellableProducerKeys = new LinkedHashSet<Key>();
    private final ListMultimap<FieldSpecKind, FieldSpec> fieldSpecsMap = MultimapBuilder.enumKeys(FieldSpecKind.class).arrayListValues().build();
    private final ListMultimap<MethodSpecKind, MethodSpec> methodSpecsMap = MultimapBuilder.enumKeys(MethodSpecKind.class).arrayListValues().build();
    private final ListMultimap<TypeSpecKind, TypeSpec> typeSpecsMap = MultimapBuilder.enumKeys(TypeSpecKind.class).arrayListValues().build();
    private final List<Supplier<TypeSpec>> typeSuppliers = new ArrayList<Supplier<TypeSpec>>();

    private ComponentImplementation(BindingGraph graph, ClassName name, SubcomponentNames subcomponentNames, CompilerOptions compilerOptions) {
        this.graph = graph;
        this.name = name;
        this.component = TypeSpec.classBuilder((ClassName)name);
        this.subcomponentNames = subcomponentNames;
        this.shardOwner = Optional.empty();
        this.externalReferenceBlock = CodeBlock.of((String)"$T.this", (Object[])new Object[]{name});
        this.compilerOptions = compilerOptions;
    }

    private ComponentImplementation(ComponentImplementation shardOwner, ClassName shardName) {
        this.graph = shardOwner.graph;
        this.name = shardName;
        this.component = TypeSpec.classBuilder((ClassName)shardName);
        this.subcomponentNames = shardOwner.subcomponentNames;
        this.compilerOptions = shardOwner.compilerOptions;
        this.shardOwner = Optional.of(shardOwner);
        String fieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.name.simpleName());
        String uniqueFieldName = shardOwner.getUniqueFieldName(fieldName);
        this.externalReferenceBlock = CodeBlock.of((String)"$T.this.$N", (Object[])new Object[]{shardOwner.name, uniqueFieldName});
        shardOwner.addTypeSupplier((Supplier<TypeSpec>)((Supplier)() -> this.generate().build()));
        shardOwner.addField(FieldSpecKind.COMPONENT_SHARD, FieldSpec.builder((TypeName)this.name, (String)uniqueFieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{this.name}).build());
    }

    public static ComponentImplementation topLevelComponentImplementation(BindingGraph graph, ClassName name, SubcomponentNames subcomponentNames, CompilerOptions compilerOptions) {
        return new ComponentImplementation(graph, name, subcomponentNames, compilerOptions);
    }

    public ComponentImplementation childComponentImplementation(BindingGraph graph) {
        Preconditions.checkState((!this.shardOwner.isPresent() ? 1 : 0) != 0, (Object)"Shards cannot create child components.");
        ClassName childName = this.getSubcomponentName(graph.componentDescriptor());
        return new ComponentImplementation(graph, childName, this.subcomponentNames, this.compilerOptions);
    }

    public ComponentImplementation shardImplementation(Key key) {
        Preconditions.checkState((!this.shardOwner.isPresent() ? 1 : 0) != 0, (Object)"Shards cannot create other shards.");
        if (!this.shardsByKey.containsKey(key)) {
            int keysPerShard = this.compilerOptions.keysPerComponentShard(this.graph.componentTypeElement());
            if (!this.shardsByKey.isEmpty() && this.shardsByKey.size() % keysPerShard == 0) {
                ClassName shardName = this.name.nestedClass("Shard" + this.shardsByKey.size() / keysPerShard);
                this.currentShard = new ComponentImplementation(this, shardName);
            }
            this.shardsByKey.put(key, this.currentShard);
        }
        return this.shardsByKey.get(key);
    }

    public CodeBlock externalReferenceBlock() {
        return this.externalReferenceBlock;
    }

    public BindingGraph graph() {
        return this.graph;
    }

    public ComponentDescriptor componentDescriptor() {
        return this.graph.componentDescriptor();
    }

    public ClassName name() {
        return this.name;
    }

    public boolean isNested() {
        return this.name.enclosingClassName() != null;
    }

    private ComponentCreatorKind creatorKind() {
        Preconditions.checkState((boolean)this.componentDescriptor().hasCreator());
        return this.componentDescriptor().creatorDescriptor().map(ComponentCreatorDescriptor::kind).orElse(ComponentCreatorKind.BUILDER);
    }

    public ClassName getCreatorName() {
        return this.isNested() ? this.name.peerClass(this.subcomponentNames.getCreatorName(this.componentDescriptor())) : this.name.nestedClass(this.creatorKind().typeName());
    }

    private ClassName getSubcomponentName(ComponentDescriptor childDescriptor) {
        Preconditions.checkArgument((boolean)this.componentDescriptor().childComponents().contains((Object)childDescriptor), (String)"%s is not a child component of %s", (Object)childDescriptor.typeElement(), (Object)this.componentDescriptor().typeElement());
        return this.name.nestedClass(this.subcomponentNames.get(childDescriptor) + "Impl");
    }

    String getSubcomponentCreatorSimpleName(Key key) {
        return this.subcomponentNames.getCreatorName(key);
    }

    boolean isTypeAccessible(TypeMirror type) {
        return Accessibility.isTypeAccessibleFrom(type, this.name.packageName());
    }

    public void addSupertype(TypeElement supertype) {
        TypeSpecs.addSupertype(this.component, supertype);
    }

    public void addField(FieldSpecKind fieldKind, FieldSpec fieldSpec) {
        this.fieldSpecsMap.put((Object)fieldKind, (Object)fieldSpec);
    }

    public void addMethod(MethodSpecKind methodKind, MethodSpec methodSpec) {
        this.methodSpecsMap.put((Object)methodKind, (Object)methodSpec);
    }

    public void addAnnotation(AnnotationSpec annotation) {
        this.component.addAnnotation(annotation);
    }

    public void addType(TypeSpecKind typeKind, TypeSpec typeSpec) {
        this.typeSpecsMap.put((Object)typeKind, (Object)typeSpec);
    }

    void addTypeSupplier(Supplier<TypeSpec> typeSpecSupplier) {
        this.typeSuppliers.add(typeSpecSupplier);
    }

    void addInitialization(CodeBlock codeBlock) {
        this.initializations.add(codeBlock);
    }

    void addComponentRequirementInitialization(CodeBlock codeBlock) {
        this.componentRequirementInitializations.add(codeBlock);
    }

    void addCancellableProducerKey(Key key) {
        this.cancellableProducerKeys.add(key);
    }

    String getUniqueFieldName(String name) {
        return this.componentFieldNames.getUniqueName(name);
    }

    public String getUniqueMethodName(String name) {
        return this.componentMethodNames.getUniqueName(name);
    }

    String getUniqueMethodName(BindingRequest request) {
        return this.uniqueMethodName(request, KeyVariableNamer.name(request.key()));
    }

    private String uniqueMethodName(BindingRequest request, String bindingName) {
        String baseMethodName = bindingName + (request.isRequestKind(RequestKind.INSTANCE) ? "" : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, request.kindName()));
        return this.getUniqueMethodName(baseMethodName);
    }

    public String getParameterName(ComponentRequirement requirement, String baseName) {
        return this.componentRequirementParameterNames.computeIfAbsent(requirement, r -> this.getUniqueFieldName(baseName));
    }

    public void claimMethodName(CharSequence name) {
        this.componentMethodNames.claim(name);
    }

    public ImmutableList<CodeBlock> getInitializations() {
        return ImmutableList.copyOf(this.initializations);
    }

    public ImmutableList<CodeBlock> getComponentRequirementInitializations() {
        return ImmutableList.copyOf(this.componentRequirementInitializations);
    }

    public ImmutableList<Key> getCancellableProducerKeys() {
        return ImmutableList.copyOf(this.cancellableProducerKeys);
    }

    public TypeSpec.Builder generate() {
        this.modifiers().forEach(xva$0 -> this.component.addModifiers(new Modifier[]{xva$0}));
        this.fieldSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addFields(arg_0));
        this.methodSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addMethods(arg_0));
        this.typeSpecsMap.asMap().values().forEach(arg_0 -> ((TypeSpec.Builder)this.component).addTypes(arg_0));
        this.typeSuppliers.stream().map(Supplier::get).forEach(arg_0 -> ((TypeSpec.Builder)this.component).addType(arg_0));
        return this.component;
    }

    private ImmutableSet<Modifier> modifiers() {
        if (this.isNested()) {
            return ImmutableSet.of((Object)((Object)Modifier.PRIVATE), (Object)((Object)Modifier.FINAL));
        }
        return this.graph.componentTypeElement().getModifiers().contains((Object)Modifier.PUBLIC) ? ImmutableSet.of((Object)((Object)Modifier.PUBLIC), (Object)((Object)Modifier.FINAL)) : ImmutableSet.of((Object)((Object)Modifier.FINAL));
    }

    public static enum TypeSpecKind {
        PRESENT_FACTORY,
        COMPONENT_CREATOR,
        COMPONENT_PROVISION_FACTORY,
        SUBCOMPONENT;

    }

    public static enum MethodSpecKind {
        CONSTRUCTOR,
        BUILDER_METHOD,
        PRIVATE_METHOD,
        INITIALIZE_METHOD,
        COMPONENT_METHOD,
        MEMBERS_INJECTION_METHOD,
        ABSENT_OPTIONAL_METHOD,
        CANCELLATION_LISTENER_METHOD;

    }

    public static enum FieldSpecKind {
        COMPONENT_SHARD,
        COMPONENT_REQUIREMENT_FIELD,
        PRIVATE_METHOD_SCOPED_FIELD,
        FRAMEWORK_FIELD,
        ABSENT_OPTIONAL_FIELD;

    }
}

