/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.base;

import dagger.internal.codegen.base.Formatter;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import java.util.stream.Collectors;
import javax.inject.Inject;

public final class ElementFormatter
extends Formatter<XElement> {
    @Inject
    ElementFormatter() {
    }

    @Override
    public String format(XElement element) {
        return ElementFormatter.elementToString(element);
    }

    public static String elementToString(XElement element) {
        if (XElements.isExecutable((XElement)element)) {
            return ElementFormatter.enclosingTypeAndMemberName(element).append(XElements.asExecutable((XElement)element).getParameters().stream().map(parameter -> XTypes.toStableString((XType)parameter.getType())).collect(Collectors.joining(", ", "(", ")"))).toString();
        }
        if (XElementKt.isMethodParameter((XElement)element)) {
            XExecutableElement methodOrConstructor = XElements.asMethodParameter((XElement)element).getEnclosingElement();
            return ElementFormatter.enclosingTypeAndMemberName((XElement)methodOrConstructor).append('(').append(ElementFormatter.formatArgumentInList(methodOrConstructor.getParameters().indexOf(element), methodOrConstructor.getParameters().size(), XElements.getSimpleName((XElement)element))).append(')').toString();
        }
        if (XElementKt.isField((XElement)element)) {
            return ElementFormatter.enclosingTypeAndMemberName(element).toString();
        }
        if (XElementKt.isTypeElement((XElement)element)) {
            return XElements.asTypeElement((XElement)element).getQualifiedName();
        }
        throw new UnsupportedOperationException("Can't determine string for element " + element);
    }

    private static StringBuilder enclosingTypeAndMemberName(XElement element) {
        StringBuilder name = new StringBuilder(ElementFormatter.elementToString(element.getEnclosingElement()));
        if (!XElements.getSimpleName((XElement)element).contentEquals("<init>")) {
            name.append('.').append(XElements.getSimpleName((XElement)element));
        }
        return name;
    }
}

