/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.bindinggraphvalidation;

import dagger.internal.codegen.binding.KeyFactory;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugin;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.DiagnosticReporter;
import dagger.spi.model.Key;
import javax.inject.Inject;
import javax.tools.Diagnostic;

final class DependsOnProductionExecutorValidator
extends ValidationBindingGraphPlugin {
    private final CompilerOptions compilerOptions;
    private final KeyFactory keyFactory;

    @Inject
    DependsOnProductionExecutorValidator(CompilerOptions compilerOptions, KeyFactory keyFactory) {
        this.compilerOptions = compilerOptions;
        this.keyFactory = keyFactory;
    }

    public String pluginName() {
        return "Dagger/DependsOnProductionExecutor";
    }

    public void visitGraph(BindingGraph bindingGraph, DiagnosticReporter diagnosticReporter) {
        if (!this.compilerOptions.usesProducers()) {
            return;
        }
        Key productionImplementationExecutorKey = this.keyFactory.forProductionImplementationExecutor();
        Key productionExecutorKey = this.keyFactory.forProductionExecutor();
        bindingGraph.network().nodes().stream().flatMap(DaggerStreams.instancesOf(BindingGraph.MaybeBinding.class)).filter(node -> node.key().equals((Object)productionExecutorKey)).flatMap(productionExecutor -> bindingGraph.requestingBindings(productionExecutor).stream()).filter(binding -> !binding.key().equals((Object)productionImplementationExecutorKey)).forEach(binding -> this.reportError(diagnosticReporter, (Binding)binding));
    }

    private void reportError(DiagnosticReporter diagnosticReporter, Binding binding) {
        diagnosticReporter.reportBinding(Diagnostic.Kind.ERROR, (BindingGraph.MaybeBinding)binding, "%s may not depend on the production executor", (Object)binding.key(), new Object[0]);
    }
}

