/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindsTypeChecker;
import dagger.internal.codegen.binding.ComponentDescriptor;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.FrameworkType;
import dagger.internal.codegen.javapoet.Expression;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.DelegateRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.spi.model.BindingKind;
import dagger.spi.model.RequestKind;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;

final class DerivedFromFrameworkInstanceRequestRepresentation
extends RequestRepresentation {
    private final ContributionBinding binding;
    private final RequestRepresentation frameworkRequestRepresentation;
    private final RequestKind requestKind;
    private final FrameworkType frameworkType;
    private final XProcessingEnv processingEnv;
    private final BindsTypeChecker bindsTypeChecker;

    @AssistedInject
    DerivedFromFrameworkInstanceRequestRepresentation(@Assisted ContributionBinding binding, @Assisted RequestRepresentation frameworkRequestRepresentation, @Assisted RequestKind requestKind, @Assisted FrameworkType frameworkType, XProcessingEnv processingEnv, BindsTypeChecker bindsTypeChecker) {
        this.binding = binding;
        this.frameworkRequestRepresentation = (RequestRepresentation)Preconditions.checkNotNull((Object)frameworkRequestRepresentation);
        this.requestKind = requestKind;
        this.frameworkType = (FrameworkType)((Object)Preconditions.checkNotNull((Object)((Object)frameworkType)));
        this.processingEnv = processingEnv;
        this.bindsTypeChecker = bindsTypeChecker;
    }

    @Override
    Expression getDependencyExpression(ClassName requestingClass) {
        Expression expression = this.frameworkType.to(this.requestKind, this.frameworkRequestRepresentation.getDependencyExpression(requestingClass), this.processingEnv);
        return this.requiresTypeCast(expression, requestingClass) ? expression.castTo(this.binding.contributedType()) : expression;
    }

    @Override
    Expression getDependencyExpressionForComponentMethod(ComponentDescriptor.ComponentMethodDescriptor componentMethod, ComponentImplementation component) {
        Expression expression = this.frameworkType.to(this.requestKind, this.frameworkRequestRepresentation.getDependencyExpressionForComponentMethod(componentMethod, component), this.processingEnv);
        return this.requiresTypeCast(expression, component.name()) ? expression.castTo(this.binding.contributedType()) : expression;
    }

    private boolean requiresTypeCast(Expression expression, ClassName requestingClass) {
        return this.binding.kind().equals((Object)BindingKind.DELEGATE) && this.requestKind.equals((Object)RequestKind.INSTANCE) && DelegateRequestRepresentation.instanceRequiresCast(this.binding, expression, requestingClass, this.bindsTypeChecker);
    }

    @AssistedFactory
    static interface Factory {
        public DerivedFromFrameworkInstanceRequestRepresentation create(ContributionBinding var1, RequestRepresentation var2, RequestKind var3, FrameworkType var4);
    }
}

