/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.binding.AutoValue_BindingNode;
import dagger.internal.codegen.binding.Binding;
import dagger.internal.codegen.binding.BindingDeclaration;
import dagger.internal.codegen.binding.BindingDeclarationFormatter;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.MultibindingDeclaration;
import dagger.internal.codegen.binding.OptionalBindingDeclaration;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.model.BindingKind;
import dagger.internal.codegen.model.ComponentPath;
import dagger.internal.codegen.model.DaggerElement;
import dagger.internal.codegen.model.DaggerTypeElement;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Key;
import dagger.internal.codegen.model.Scope;
import java.util.Optional;

@AutoValue
public abstract class BindingNode
implements dagger.internal.codegen.model.Binding {
    private BindingDeclarationFormatter bindingDeclarationFormatter;

    public static BindingNode create(ComponentPath component, Binding delegate, ImmutableSet<MultibindingDeclaration> multibindingDeclarations, ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations, ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations, BindingDeclarationFormatter bindingDeclarationFormatter) {
        AutoValue_BindingNode node = new AutoValue_BindingNode(component, delegate, multibindingDeclarations, optionalBindingDeclarations, subcomponentDeclarations);
        node.bindingDeclarationFormatter = (BindingDeclarationFormatter)Preconditions.checkNotNull((Object)bindingDeclarationFormatter);
        return node;
    }

    public abstract Binding delegate();

    public abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    public abstract ImmutableSet<OptionalBindingDeclaration> optionalBindingDeclarations();

    public abstract ImmutableSet<SubcomponentDeclaration> subcomponentDeclarations();

    public final Iterable<BindingDeclaration> associatedDeclarations() {
        return Iterables.concat(this.multibindingDeclarations(), this.optionalBindingDeclarations(), this.subcomponentDeclarations());
    }

    @Override
    public Key key() {
        return this.delegate().key();
    }

    @Override
    public ImmutableSet<DependencyRequest> dependencies() {
        return this.delegate().dependencies();
    }

    @Override
    public Optional<DaggerElement> bindingElement() {
        return this.delegate().bindingElement().map(DaggerElement::from);
    }

    @Override
    public Optional<DaggerTypeElement> contributingModule() {
        return this.delegate().contributingModule().map(DaggerTypeElement::from);
    }

    @Override
    public boolean requiresModuleInstance() {
        return this.delegate().requiresModuleInstance();
    }

    @Override
    public Optional<Scope> scope() {
        return this.delegate().scope();
    }

    @Override
    public boolean isNullable() {
        return this.delegate().isNullable();
    }

    @Override
    public boolean isProduction() {
        return this.delegate().bindingType().equals((Object)BindingType.PRODUCTION);
    }

    @Override
    public BindingKind kind() {
        return this.delegate().kind();
    }

    public final String toString() {
        return this.bindingDeclarationFormatter.format(this.delegate());
    }
}

