/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.Origin;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XEnumEntry;
import dagger.spi.shaded.androidx.room.compiler.processing.XEnumTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XHasModifiers;
import dagger.spi.shaded.androidx.room.compiler.processing.XMemberContainer;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

public final class XElements {
    public static String getSimpleName(XMemberContainer memberContainer) {
        return memberContainer.getClassName().simpleName();
    }

    public static String getSimpleName(XElement element) {
        if (XElementKt.isTypeElement((XElement)element)) {
            return XElements.asTypeElement(element).getName();
        }
        if (XElementKt.isVariableElement((XElement)element)) {
            return XElements.asVariable(element).getName();
        }
        if (XElements.isEnumEntry(element)) {
            return XElements.asEnumEntry(element).getName();
        }
        if (XElementKt.isMethod((XElement)element)) {
            return XElements.asMethod(element).getJvmName();
        }
        if (XElementKt.isConstructor((XElement)element)) {
            return "<init>";
        }
        if (XElements.isTypeParameter(element)) {
            return XElements.asTypeParameter(element).getName();
        }
        throw new AssertionError((Object)("No simple name for: " + element));
    }

    private static boolean isSyntheticElement(XElement element) {
        if (XElementKt.isMethodParameter((XElement)element)) {
            XExecutableParameterElement executableParam = XElements.asMethodParameter(element);
            return executableParam.isContinuationParam() || executableParam.isReceiverParam() || executableParam.isKotlinPropertyParam();
        }
        if (XElementKt.isMethod((XElement)element)) {
            return XElements.asMethod(element).isKotlinPropertyMethod();
        }
        return false;
    }

    @Nullable
    public static KSAnnotated toKSAnnotated(XElement element) {
        if (XElements.isSyntheticElement(element)) {
            return XConverters.toKS((XElement)element);
        }
        if (XElements.isExecutable(element)) {
            return XConverters.toKS((XExecutableElement)XElements.asExecutable(element));
        }
        if (XElementKt.isTypeElement((XElement)element)) {
            return XConverters.toKS((XTypeElement)XElements.asTypeElement(element));
        }
        if (XElementKt.isField((XElement)element)) {
            return XConverters.toKS((XFieldElement)XElements.asField(element));
        }
        if (XElementKt.isMethodParameter((XElement)element)) {
            return XConverters.toKS((XExecutableParameterElement)XElements.asMethodParameter(element));
        }
        throw new IllegalStateException("Returning KSAnnotated declaration for " + element + " is not supported.");
    }

    public static XTypeElement closestEnclosingTypeElement(XElement element) {
        return XElements.optionalClosestEnclosingTypeElement(element).orElseThrow(() -> new IllegalStateException("No enclosing TypeElement for: " + element));
    }

    public static boolean transitivelyEncloses(XElement encloser, XElement enclosed) {
        for (XElement current = enclosed; current != null; current = current.getEnclosingElement()) {
            if (!current.equals(encloser)) continue;
            return true;
        }
        return false;
    }

    private static Optional<XTypeElement> optionalClosestEnclosingTypeElement(XElement element) {
        if (XElementKt.isTypeElement((XElement)element)) {
            return Optional.of(XElements.asTypeElement(element));
        }
        if (XElementKt.isConstructor((XElement)element)) {
            return Optional.of(XElements.asConstructor(element).getEnclosingElement());
        }
        if (XElementKt.isMethod((XElement)element)) {
            return XElements.optionalClosestEnclosingTypeElement((XElement)XElements.asMethod(element).getEnclosingElement());
        }
        if (XElementKt.isField((XElement)element)) {
            return XElements.optionalClosestEnclosingTypeElement((XElement)XElements.asField(element).getEnclosingElement());
        }
        if (XElementKt.isMethodParameter((XElement)element)) {
            return XElements.optionalClosestEnclosingTypeElement((XElement)XElements.asMethodParameter(element).getEnclosingElement());
        }
        return Optional.empty();
    }

    public static boolean isAbstract(XElement element) {
        return XElements.asHasModifiers(element).isAbstract();
    }

    public static boolean isPublic(XElement element) {
        return XElements.asHasModifiers(element).isPublic();
    }

    public static boolean isPrivate(XElement element) {
        return XElements.asHasModifiers(element).isPrivate();
    }

    public static boolean isStatic(XElement element) {
        return XElements.asHasModifiers(element).isStatic();
    }

    private static XHasModifiers asHasModifiers(XElement element) {
        Preconditions.checkArgument((boolean)(element instanceof XHasModifiers), (String)"Element %s does not have modifiers", (Object)element);
        return (XHasModifiers)element;
    }

    public static boolean isPackage(XElement element) {
        if (XConverters.getProcessingEnv((XElement)element).getBackend() == XProcessingEnv.Backend.JAVAC) {
            Preconditions.checkState((XConverters.toJavac((XElement)element).getKind() != ElementKind.PACKAGE ? 1 : 0) != 0);
        }
        return false;
    }

    public static boolean isTypeParameter(XElement element) {
        return element instanceof XTypeParameterElement;
    }

    public static XTypeParameterElement asTypeParameter(XElement element) {
        return (XTypeParameterElement)element;
    }

    public static boolean isEnumEntry(XElement element) {
        return element instanceof XEnumEntry;
    }

    public static boolean isEnum(XElement element) {
        return element instanceof XEnumTypeElement;
    }

    public static boolean isExecutable(XElement element) {
        return XElementKt.isConstructor((XElement)element) || XElementKt.isMethod((XElement)element);
    }

    public static XExecutableElement asExecutable(XElement element) {
        Preconditions.checkState((boolean)XElements.isExecutable(element));
        return (XExecutableElement)element;
    }

    public static XTypeElement asTypeElement(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isTypeElement((XElement)element));
        return (XTypeElement)element;
    }

    public static XExecutableParameterElement asMethodParameter(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethodParameter((XElement)element));
        return (XExecutableParameterElement)element;
    }

    public static XFieldElement asField(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isField((XElement)element));
        return (XFieldElement)element;
    }

    public static XEnumEntry asEnumEntry(XElement element) {
        return (XEnumEntry)element;
    }

    public static XVariableElement asVariable(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isVariableElement((XElement)element));
        return (XVariableElement)element;
    }

    public static XConstructorElement asConstructor(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isConstructor((XElement)element));
        return (XConstructorElement)element;
    }

    public static XMethodElement asMethod(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethod((XElement)element));
        return (XMethodElement)element;
    }

    public static ImmutableSet<XAnnotation> getAnnotatedAnnotations(XAnnotated annotated, ClassName annotationName) {
        return (ImmutableSet)annotated.getAllAnnotations().stream().filter(annotation -> annotation.getType().getTypeElement().hasAnnotation(annotationName)).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, ClassName ... annotations) {
        return XElements.hasAnyAnnotation(annotated, (Collection<ClassName>)ImmutableSet.copyOf((Object[])annotations));
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, Collection<ClassName> annotations) {
        return annotations.stream().anyMatch(arg_0 -> ((XAnnotated)annotated).hasAnnotation(arg_0));
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, ClassName ... annotations) {
        return XElements.getAnyAnnotation(annotated, (Collection<ClassName>)ImmutableSet.copyOf((Object[])annotations));
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, Collection<ClassName> annotations) {
        return annotations.stream().filter(arg_0 -> ((XAnnotated)annotated).hasAnnotation(arg_0)).map(arg_0 -> ((XAnnotated)annotated).getAnnotation(arg_0)).findFirst();
    }

    public static ImmutableSet<XAnnotation> getAllAnnotations(XAnnotated annotated, Collection<ClassName> annotations) {
        return (ImmutableSet)annotations.stream().filter(arg_0 -> ((XAnnotated)annotated).hasAnnotation(arg_0)).map(arg_0 -> ((XAnnotated)annotated).getAnnotation(arg_0)).collect(DaggerStreams.toImmutableSet());
    }

    public static String toStableString(XElement element) {
        if (element == null) {
            return "<null>";
        }
        try {
            if (XElementKt.isTypeElement((XElement)element)) {
                return XElements.asTypeElement(element).getQualifiedName();
            }
            if (XElements.isExecutable(element)) {
                XExecutableElement executable = XElements.asExecutable(element);
                return String.format("%s(%s)", XElements.getSimpleName((XElement)(XElementKt.isConstructor((XElement)element) ? XElements.asConstructor(element).getEnclosingElement() : executable)), executable.getParameters().stream().map(XVariableElement::getType).map(XTypes::toStableString).collect(Collectors.joining(",")));
            }
            if (XElements.isEnumEntry(element) || XElementKt.isField((XElement)element) || XElementKt.isMethodParameter((XElement)element) || XElements.isTypeParameter(element)) {
                return XElements.getSimpleName(element);
            }
            return element.toString();
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    public static String getKindName(XElement element) {
        if (XElementKt.isTypeElement((XElement)element)) {
            XTypeElement typeElement = XElements.asTypeElement(element);
            if (typeElement.isClass()) {
                return "CLASS";
            }
            if (typeElement.isInterface()) {
                return "INTERFACE";
            }
            if (typeElement.isAnnotationClass()) {
                return "ANNOTATION_TYPE";
            }
        } else {
            if (XElements.isEnum(element)) {
                return "ENUM";
            }
            if (XElements.isEnumEntry(element)) {
                return "ENUM_CONSTANT";
            }
            if (XElementKt.isConstructor((XElement)element)) {
                return "CONSTRUCTOR";
            }
            if (XElementKt.isMethod((XElement)element)) {
                return "METHOD";
            }
            if (XElementKt.isField((XElement)element)) {
                return "FIELD";
            }
            if (XElementKt.isMethodParameter((XElement)element)) {
                return "PARAMETER";
            }
            if (XElements.isTypeParameter(element)) {
                return "TYPE_PARAMETER";
            }
        }
        return element.kindName();
    }

    public static String packageName(XElement element) {
        return element.getClosestMemberContainer().asClassName().getPackageName();
    }

    public static boolean isFromJavaSource(XElement element) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv((XElement)element);
        switch (processingEnv.getBackend()) {
            case KSP: {
                Origin origin = XConverters.toKS((XElement)element).getOrigin();
                return origin == Origin.JAVA || origin == Origin.JAVA_LIB;
            }
            case JAVAC: {
                return !XElements.hasKotlinMetadata(element);
            }
        }
        throw new AssertionError((Object)("Unhandled backend kind: " + processingEnv.getBackend()));
    }

    public static boolean isFromKotlinSource(XElement element) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv((XElement)element);
        switch (processingEnv.getBackend()) {
            case KSP: {
                Origin origin = XConverters.toKS((XElement)element).getOrigin();
                return origin == Origin.KOTLIN || origin == Origin.KOTLIN_LIB;
            }
            case JAVAC: {
                return XElements.hasKotlinMetadata(element);
            }
        }
        throw new AssertionError((Object)("Unhandled backend kind: " + processingEnv.getBackend()));
    }

    private static boolean hasKotlinMetadata(XElement element) {
        return XElements.closestEnclosingTypeElement(element).hasAnnotation(ClassName.get((String)"kotlin", (String)"Metadata", (String[])new String[0]));
    }

    private XElements() {
    }
}

