/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.Binds;
import dagger.BindsInstance;
import dagger.Component;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.DaggerDelegateComponentProcessor_Injector;
import dagger.internal.codegen.ProcessingEnvironmentModule;
import dagger.internal.codegen.ServiceLoaders;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.SourceFileGenerationException;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.BindingGraphFactory;
import dagger.internal.codegen.binding.InjectBindingRegistry;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.ProvisionBinding;
import dagger.internal.codegen.bindinggraphvalidation.BindingGraphValidationModule;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.componentgenerator.ComponentGeneratorModule;
import dagger.internal.codegen.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.processingstep.ProcessingStepsModule;
import dagger.internal.codegen.validation.AnyBindingMethodValidator;
import dagger.internal.codegen.validation.BindingMethodValidatorsModule;
import dagger.internal.codegen.validation.ComponentCreatorValidator;
import dagger.internal.codegen.validation.ComponentValidator;
import dagger.internal.codegen.validation.External;
import dagger.internal.codegen.validation.ExternalBindingGraphPlugins;
import dagger.internal.codegen.validation.InjectBindingRegistryModule;
import dagger.internal.codegen.validation.InjectValidator;
import dagger.internal.codegen.validation.ValidationBindingGraphPlugins;
import dagger.internal.codegen.writing.FactoryGenerator;
import dagger.internal.codegen.writing.HjarSourceFileGenerator;
import dagger.internal.codegen.writing.MembersInjectorGenerator;
import dagger.internal.codegen.writing.ModuleGenerator;
import dagger.internal.codegen.writing.ModuleProxies;
import dagger.internal.codegen.writing.ProducerFactoryGenerator;
import dagger.multibindings.IntoSet;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnvConfig;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingStep;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.tools.Diagnostic;

final class DelegateComponentProcessor {
    static final XProcessingEnvConfig PROCESSING_ENV_CONFIG = new XProcessingEnvConfig.Builder().disableAnnotatedElementValidation(true).build();
    @Inject
    InjectBindingRegistry injectBindingRegistry;
    @Inject
    SourceFileGenerator<ProvisionBinding> factoryGenerator;
    @Inject
    SourceFileGenerator<MembersInjectionBinding> membersInjectorGenerator;
    @Inject
    ImmutableList<XProcessingStep> processingSteps;
    @Inject
    ValidationBindingGraphPlugins validationBindingGraphPlugins;
    @Inject
    ExternalBindingGraphPlugins externalBindingGraphPlugins;
    @Inject
    Set<ClearableCache> clearableCaches;

    DelegateComponentProcessor() {
    }

    public void initialize(XProcessingEnv env, Optional<ImmutableSet<dagger.spi.model.BindingGraphPlugin>> testingPlugins, Optional<ImmutableSet<BindingGraphPlugin>> legacyTestingPlugins) {
        ImmutableSet plugins = testingPlugins.orElseGet(() -> ServiceLoaders.loadServices(env, dagger.spi.model.BindingGraphPlugin.class));
        ImmutableSet legacyPlugins = legacyTestingPlugins.orElseGet(() -> ServiceLoaders.loadServices(env, BindingGraphPlugin.class));
        if (env.getBackend() != XProcessingEnv.Backend.JAVAC) {
            legacyPlugins.forEach(legacyPlugin -> env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot use legacy dagger.spi.BindingGraphPlugin while compiling with KSP: " + legacyPlugin.pluginName() + ". Either compile with KAPT or migrate the plugin to implement dagger.spi.model.BindingGraphPlugin."));
            legacyPlugins = ImmutableSet.of();
        }
        DaggerDelegateComponentProcessor_Injector.factory().create(env, (ImmutableSet<dagger.spi.model.BindingGraphPlugin>)plugins, (ImmutableSet<BindingGraphPlugin>)legacyPlugins).inject(this);
    }

    public Iterable<XProcessingStep> processingSteps() {
        this.validationBindingGraphPlugins.initializePlugins();
        this.externalBindingGraphPlugins.initializePlugins();
        return this.processingSteps;
    }

    public void postRound(XProcessingEnv env, XRoundEnv roundEnv) {
        if (!roundEnv.isProcessingOver()) {
            try {
                this.injectBindingRegistry.generateSourcesForRequiredBindings(this.factoryGenerator, this.membersInjectorGenerator);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(env.getMessager());
            }
        } else {
            this.validationBindingGraphPlugins.endPlugins();
            this.externalBindingGraphPlugins.endPlugins();
        }
        this.clearableCaches.forEach(ClearableCache::clearCache);
    }

    private static <T> SourceFileGenerator<T> hjarWrapper(SourceFileGenerator<T> generator, CompilerOptions compilerOptions) {
        return compilerOptions.headerCompilation() ? HjarSourceFileGenerator.wrap(generator) : generator;
    }

    @Module
    static interface SourceFileGeneratorsModule {
        @Provides
        public static SourceFileGenerator<ProvisionBinding> factoryGenerator(FactoryGenerator generator, CompilerOptions compilerOptions) {
            return DelegateComponentProcessor.hjarWrapper(generator, compilerOptions);
        }

        @Provides
        public static SourceFileGenerator<ProductionBinding> producerFactoryGenerator(ProducerFactoryGenerator generator, CompilerOptions compilerOptions) {
            return DelegateComponentProcessor.hjarWrapper(generator, compilerOptions);
        }

        @Provides
        public static SourceFileGenerator<MembersInjectionBinding> membersInjectorGenerator(MembersInjectorGenerator generator, CompilerOptions compilerOptions) {
            return DelegateComponentProcessor.hjarWrapper(generator, compilerOptions);
        }

        @Provides
        @ModuleGenerator
        public static SourceFileGenerator<XTypeElement> moduleConstructorProxyGenerator(ModuleProxies.ModuleConstructorProxyGenerator generator, CompilerOptions compilerOptions) {
            return DelegateComponentProcessor.hjarWrapper(generator, compilerOptions);
        }
    }

    @Module
    static interface ProcessingRoundCacheModule {
        @Binds
        @IntoSet
        public ClearableCache anyBindingMethodValidator(AnyBindingMethodValidator var1);

        @Binds
        @IntoSet
        public ClearableCache injectValidator(InjectValidator var1);

        @Binds
        @IntoSet
        public ClearableCache moduleDescriptorFactory(ModuleDescriptor.Factory var1);

        @Binds
        @IntoSet
        public ClearableCache bindingGraphFactory(BindingGraphFactory var1);

        @Binds
        @IntoSet
        public ClearableCache componentValidator(ComponentValidator var1);

        @Binds
        @IntoSet
        public ClearableCache componentCreatorValidator(ComponentCreatorValidator var1);

        @Binds
        @IntoSet
        public ClearableCache kotlinMetadata(KotlinMetadataFactory var1);
    }

    @Singleton
    @Component(modules={BindingGraphValidationModule.class, BindingMethodValidatorsModule.class, ComponentGeneratorModule.class, InjectBindingRegistryModule.class, ProcessingEnvironmentModule.class, ProcessingRoundCacheModule.class, ProcessingStepsModule.class, SourceFileGeneratorsModule.class})
    static interface Injector {
        public void inject(DelegateComponentProcessor var1);

        @Component.Factory
        public static interface Factory {
            @CheckReturnValue
            public Injector create(@BindsInstance XProcessingEnv var1, @BindsInstance @External ImmutableSet<dagger.spi.model.BindingGraphPlugin> var2, @BindsInstance @External ImmutableSet<BindingGraphPlugin> var3);
        }
    }
}

