/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.base.ComponentAnnotation;
import dagger.internal.codegen.base.ComponentCreatorAnnotation;
import dagger.internal.codegen.base.DaggerSuperficialValidation;
import dagger.internal.codegen.base.ModuleAnnotation;
import dagger.internal.codegen.base.Scopes;
import dagger.internal.codegen.binding.AutoValue_ComponentDescriptor;
import dagger.internal.codegen.binding.AutoValue_ComponentDescriptor_ComponentMethodDescriptor;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.CancellationPolicy;
import dagger.internal.codegen.binding.ComponentCreatorDescriptor;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.binding.ConfigurationAnnotations;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.DependencyRequestFactory;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.binding.ModuleDescriptor;
import dagger.internal.codegen.binding.SubcomponentDeclaration;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.Scope;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

@CheckReturnValue
@AutoValue
public abstract class ComponentDescriptor {
    private final Supplier<ImmutableMap<XTypeElement, ComponentDescriptor>> childComponentsByBuilderType = Suppliers.memoize(() -> (ImmutableMap)this.childComponents().stream().filter(child -> child.creatorDescriptor().isPresent()).collect(DaggerStreams.toImmutableMap(child -> child.creatorDescriptor().get().typeElement(), child -> child)));
    private static final ImmutableSet<String> NON_CONTRIBUTING_OBJECT_METHOD_NAMES = ImmutableSet.of((Object)"toString", (Object)"hashCode", (Object)"clone", (Object)"getClass");

    public abstract ComponentAnnotation annotation();

    public abstract XTypeElement typeElement();

    public abstract ImmutableSet<ComponentRequirement> dependencies();

    public abstract ImmutableSet<ModuleDescriptor> modules();

    public abstract ImmutableSet<Scope> scopes();

    abstract ImmutableSet<ComponentDescriptor> childComponentsDeclaredByModules();

    public abstract ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByFactoryMethods();

    abstract ImmutableMap<ComponentMethodDescriptor, ComponentDescriptor> childComponentsDeclaredByBuilderEntryPoints();

    public abstract ImmutableSet<ComponentMethodDescriptor> componentMethods();

    public abstract Optional<ComponentCreatorDescriptor> creatorDescriptor();

    public final boolean isSubcomponent() {
        return this.annotation().isSubcomponent();
    }

    public final boolean isProduction() {
        return this.annotation().isProduction();
    }

    public final boolean isRealComponent() {
        return this.annotation().isRealComponent();
    }

    public final ImmutableSet<ComponentRequirement> dependenciesAndConcreteModules() {
        return (ImmutableSet)Stream.concat(this.moduleTypes().stream().filter(dep -> !dep.isAbstract()).map(module -> ComponentRequirement.forModule(module.getType())), this.dependencies().stream()).collect(DaggerStreams.toImmutableSet());
    }

    public final ImmutableSet<XTypeElement> moduleTypes() {
        return (ImmutableSet)this.modules().stream().map(ModuleDescriptor::moduleElement).collect(DaggerStreams.toImmutableSet());
    }

    @Memoized
    ImmutableSet<ComponentRequirement> requirements() {
        ImmutableSet.Builder requirements = ImmutableSet.builder();
        this.modules().stream().filter(module -> module.bindings().stream().anyMatch(ContributionBinding::requiresModuleInstance)).map(module -> ComponentRequirement.forModule(module.moduleElement().getType())).forEach(arg_0 -> ((ImmutableSet.Builder)requirements).add(arg_0));
        requirements.addAll(this.dependencies());
        requirements.addAll((Iterable)this.creatorDescriptor().map(ComponentCreatorDescriptor::boundInstanceRequirements).orElse(ImmutableSet.of()));
        return requirements.build();
    }

    @Memoized
    public ImmutableMap<XMethodElement, ComponentRequirement> dependenciesByDependencyMethod() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ComponentRequirement componentDependency : this.dependencies()) {
            XTypeElements.getAllMethods(componentDependency.typeElement()).stream().filter(ComponentDescriptor::isComponentContributionMethod).forEach(method -> builder.put(method, (Object)componentDependency));
        }
        return builder.buildOrThrow();
    }

    public final ComponentRequirement getDependencyThatDefinesMethod(XElement method) {
        Preconditions.checkArgument((boolean)XElementKt.isMethod((XElement)method), (String)"method must be an executable element: %s", (Object)method);
        Preconditions.checkState((boolean)this.dependenciesByDependencyMethod().containsKey((Object)method), (String)"no dependency implements %s", (Object)method);
        return (ComponentRequirement)this.dependenciesByDependencyMethod().get((Object)method);
    }

    public final ImmutableSet<ComponentDescriptor> childComponents() {
        return ImmutableSet.builder().addAll((Iterable)this.childComponentsDeclaredByFactoryMethods().values()).addAll((Iterable)this.childComponentsDeclaredByBuilderEntryPoints().values()).addAll(this.childComponentsDeclaredByModules()).build();
    }

    @Memoized
    public ImmutableMap<XTypeElement, ComponentDescriptor> childComponentsByElement() {
        return Maps.uniqueIndex(this.childComponents(), ComponentDescriptor::typeElement);
    }

    final Optional<ComponentMethodDescriptor> getFactoryMethodForChildComponent(ComponentDescriptor childComponent) {
        return Optional.ofNullable((ComponentMethodDescriptor)this.childComponentsDeclaredByFactoryMethods().inverse().get((Object)childComponent));
    }

    final ComponentDescriptor getChildComponentWithBuilderType(XTypeElement builderType) {
        return (ComponentDescriptor)Preconditions.checkNotNull((Object)((ComponentDescriptor)((ImmutableMap)this.childComponentsByBuilderType.get()).get((Object)builderType)), (String)"no child component found for builder type %s", (Object)builderType.getQualifiedName());
    }

    public Optional<ComponentMethodDescriptor> firstMatchingComponentMethod(BindingRequest request) {
        return Optional.ofNullable((ComponentMethodDescriptor)this.firstMatchingComponentMethods().get((Object)request));
    }

    @Memoized
    ImmutableMap<BindingRequest, ComponentMethodDescriptor> firstMatchingComponentMethods() {
        HashMap<BindingRequest, ComponentMethodDescriptor> methods = new HashMap<BindingRequest, ComponentMethodDescriptor>();
        for (ComponentMethodDescriptor method : this.entryPointMethods()) {
            methods.putIfAbsent(BindingRequest.bindingRequest(method.dependencyRequest().get()), method);
        }
        return ImmutableMap.copyOf(methods);
    }

    public final ImmutableSet<ComponentMethodDescriptor> entryPointMethods() {
        return (ImmutableSet)this.componentMethods().stream().filter(method -> method.dependencyRequest().isPresent()).collect(DaggerStreams.toImmutableSet());
    }

    public final boolean hasCreator() {
        return !this.isSubcomponent() || this.creatorDescriptor().isPresent();
    }

    public final Optional<CancellationPolicy> cancellationPolicy() {
        return this.isProduction() ? Optional.ofNullable(this.typeElement().getAnnotation(TypeNames.CANCELLATION_POLICY)).map(CancellationPolicy::from) : Optional.empty();
    }

    @Memoized
    public int hashCode() {
        return Objects.hash(this.typeElement(), this.annotation());
    }

    public abstract boolean equals(Object var1);

    static boolean isComponentContributionMethod(XMethodElement method) {
        return method.getParameters().isEmpty() && !XTypeKt.isVoid((XType)method.getReturnType()) && !method.getEnclosingElement().getClassName().equals((Object)TypeName.OBJECT) && !NON_CONTRIBUTING_OBJECT_METHOD_NAMES.contains((Object)XElements.getSimpleName((XElement)method));
    }

    static boolean isComponentProductionMethod(XMethodElement method) {
        return ComponentDescriptor.isComponentContributionMethod(method) && TypeNames.isFutureType(method.getReturnType());
    }

    public static final class Factory {
        private final XProcessingEnv processingEnv;
        private final DependencyRequestFactory dependencyRequestFactory;
        private final ModuleDescriptor.Factory moduleDescriptorFactory;
        private final InjectionAnnotations injectionAnnotations;
        private final DaggerSuperficialValidation superficialValidation;

        @Inject
        Factory(XProcessingEnv processingEnv, DependencyRequestFactory dependencyRequestFactory, ModuleDescriptor.Factory moduleDescriptorFactory, InjectionAnnotations injectionAnnotations, DaggerSuperficialValidation superficialValidation) {
            this.processingEnv = processingEnv;
            this.dependencyRequestFactory = dependencyRequestFactory;
            this.moduleDescriptorFactory = moduleDescriptorFactory;
            this.injectionAnnotations = injectionAnnotations;
            this.superficialValidation = superficialValidation;
        }

        public ComponentDescriptor rootComponentDescriptor(XTypeElement typeElement) {
            Optional<ComponentAnnotation> annotation = ComponentAnnotation.rootComponentAnnotation(typeElement, this.superficialValidation);
            Preconditions.checkArgument((boolean)annotation.isPresent(), (String)"%s must have a component annotation", (Object)typeElement);
            return this.create(typeElement, annotation.get());
        }

        public ComponentDescriptor subcomponentDescriptor(XTypeElement typeElement) {
            Optional<ComponentAnnotation> annotation = ComponentAnnotation.subcomponentAnnotation(typeElement, this.superficialValidation);
            Preconditions.checkArgument((boolean)annotation.isPresent(), (String)"%s must have a subcomponent annotation", (Object)typeElement);
            return this.create(typeElement, annotation.get());
        }

        public ComponentDescriptor moduleComponentDescriptor(XTypeElement typeElement) {
            Optional<ModuleAnnotation> annotation = ModuleAnnotation.moduleAnnotation((XElement)typeElement, this.superficialValidation);
            Preconditions.checkArgument((boolean)annotation.isPresent(), (String)"%s must have a module annotation", (Object)typeElement);
            return this.create(typeElement, ComponentAnnotation.fromModuleAnnotation(annotation.get()));
        }

        private ComponentDescriptor create(XTypeElement typeElement, ComponentAnnotation componentAnnotation) {
            ImmutableSet<XTypeElement> enclosedCreators;
            ImmutableSet componentDependencies = (ImmutableSet)componentAnnotation.dependencyTypes().stream().map(ComponentRequirement::forDependency).collect(DaggerStreams.toImmutableSet());
            ImmutableSet modules = componentAnnotation.isRealComponent() ? componentAnnotation.modules() : ImmutableSet.of((Object)typeElement);
            ImmutableSet<ModuleDescriptor> transitiveModules = this.moduleDescriptorFactory.transitiveModules((Collection<XTypeElement>)modules);
            ImmutableSet.Builder componentMethodsBuilder = ImmutableSet.builder();
            ImmutableBiMap.Builder subcomponentsByFactoryMethod = ImmutableBiMap.builder();
            ImmutableBiMap.Builder subcomponentsByBuilderMethod = ImmutableBiMap.builder();
            if (componentAnnotation.isRealComponent()) {
                for (XMethodElement componentMethod : XTypeElements.getAllUnimplementedMethods(typeElement)) {
                    ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(componentAnnotation, typeElement, componentMethod);
                    componentMethodsBuilder.add((Object)componentMethodDescriptor);
                    componentMethodDescriptor.subcomponent().ifPresent(arg_0 -> Factory.lambda$create$0(componentMethodDescriptor, (ImmutableMap.Builder)subcomponentsByBuilderMethod, subcomponentsByFactoryMethod, arg_0));
                }
            }
            Optional<ComponentCreatorDescriptor> creatorDescriptor = (enclosedCreators = ConfigurationAnnotations.enclosedAnnotatedTypes(typeElement, ComponentCreatorAnnotation.creatorAnnotationsFor(componentAnnotation))).isEmpty() ? Optional.empty() : Optional.of(ComponentCreatorDescriptor.create((XTypeElement)Iterables.getOnlyElement(enclosedCreators), this.dependencyRequestFactory));
            ImmutableSet scopes = this.injectionAnnotations.getScopes((XElement)typeElement);
            if (componentAnnotation.isProduction()) {
                scopes = ImmutableSet.builder().addAll(scopes).add((Object)Scopes.productionScope(this.processingEnv)).build();
            }
            ImmutableSet subcomponentsFromModules = (ImmutableSet)transitiveModules.stream().flatMap(transitiveModule -> transitiveModule.subcomponentDeclarations().stream()).map(SubcomponentDeclaration::subcomponentType).map(this::subcomponentDescriptor).collect(DaggerStreams.toImmutableSet());
            return new AutoValue_ComponentDescriptor(componentAnnotation, typeElement, (ImmutableSet<ComponentRequirement>)componentDependencies, transitiveModules, (ImmutableSet<Scope>)scopes, (ImmutableSet<ComponentDescriptor>)subcomponentsFromModules, (ImmutableBiMap<ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByFactoryMethod.buildOrThrow(), (ImmutableMap<ComponentMethodDescriptor, ComponentDescriptor>)subcomponentsByBuilderMethod.buildOrThrow(), (ImmutableSet<ComponentMethodDescriptor>)componentMethodsBuilder.build(), creatorDescriptor);
        }

        private ComponentMethodDescriptor getDescriptorForComponentMethod(ComponentAnnotation componentAnnotation, XTypeElement componentElement, XMethodElement componentMethod) {
            ComponentMethodDescriptor.Builder descriptor = ComponentMethodDescriptor.builder(componentMethod);
            XMethodType resolvedComponentMethod = componentMethod.asMemberOf(componentElement.getType());
            XType returnType = resolvedComponentMethod.getReturnType();
            if (XTypes.isDeclared(returnType) && !this.injectionAnnotations.getQualifier((XElement)componentMethod).isPresent()) {
                XTypeElement returnTypeElement = returnType.getTypeElement();
                if (returnTypeElement.hasAnyAnnotation(ComponentAnnotation.subcomponentAnnotations())) {
                    return descriptor.subcomponent(this.subcomponentDescriptor(returnTypeElement)).build();
                }
                if (ConfigurationAnnotations.isSubcomponentCreator((XElement)returnTypeElement)) {
                    descriptor.subcomponent(this.subcomponentDescriptor(returnTypeElement.getEnclosingTypeElement()));
                }
            }
            switch (componentMethod.getParameters().size()) {
                case 0: {
                    Preconditions.checkArgument((!XTypeKt.isVoid((XType)returnType) ? 1 : 0) != 0, (String)"component method cannot be void: %s", (Object)componentMethod);
                    descriptor.dependencyRequest(componentAnnotation.isProduction() ? this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, resolvedComponentMethod) : this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod));
                    break;
                }
                case 1: {
                    Preconditions.checkArgument((XTypeKt.isVoid((XType)returnType) || returnType.getTypeName().equals((Object)((XType)resolvedComponentMethod.getParameterTypes().get(0)).getTypeName()) ? 1 : 0) != 0, (String)"members injection method must return void or parameter type: %s", (Object)componentMethod);
                    descriptor.dependencyRequest(this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("component method has too many parameters: " + componentMethod);
                }
            }
            return descriptor.build();
        }

        private static /* synthetic */ void lambda$create$0(ComponentMethodDescriptor componentMethodDescriptor, ImmutableMap.Builder subcomponentsByBuilderMethod, ImmutableBiMap.Builder subcomponentsByFactoryMethod, ComponentDescriptor subcomponent) {
            if (componentMethodDescriptor.dependencyRequest().isPresent()) {
                subcomponentsByBuilderMethod.put((Object)componentMethodDescriptor, (Object)subcomponent);
            } else {
                subcomponentsByFactoryMethod.put((Object)componentMethodDescriptor, (Object)subcomponent);
            }
        }
    }

    @AutoValue
    public static abstract class ComponentMethodDescriptor {
        public abstract XMethodElement methodElement();

        public abstract Optional<DependencyRequest> dependencyRequest();

        public abstract Optional<ComponentDescriptor> subcomponent();

        public static Builder builder(XMethodElement method) {
            return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor.Builder().methodElement(method);
        }

        @AutoValue.Builder
        public static interface Builder {
            public Builder methodElement(XMethodElement var1);

            @CanIgnoreReturnValue
            public Builder dependencyRequest(DependencyRequest var1);

            @CanIgnoreReturnValue
            public Builder subcomponent(ComponentDescriptor var1);

            public ComponentMethodDescriptor build();
        }
    }
}

