/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.binding;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.;
import dagger.internal.codegen.binding.BindingType;
import dagger.internal.codegen.binding.ContributionBinding;
import dagger.internal.codegen.binding.Nullability;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.javapoet.TypeNames;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Optional;
import java.util.stream.Stream;

@CheckReturnValue
@AutoValue
public abstract class ProductionBinding
extends ContributionBinding {
    @Override
    public BindingType bindingType() {
        return BindingType.PRODUCTION;
    }

    public abstract Optional<ProductionBinding> unresolved();

    @Override
    public ImmutableSet<DependencyRequest> implicitDependencies() {
        return (ImmutableSet)Stream.of(this.executorRequest(), this.monitorRequest()).filter(Optional::isPresent).map(Optional::get).collect(DaggerStreams.toImmutableSet());
    }

    public abstract Optional<ProductionKind> productionKind();

    public abstract ImmutableList<XType> thrownTypes();

    abstract Optional<DependencyRequest> executorRequest();

    abstract Optional<DependencyRequest> monitorRequest();

    @Override
    @Memoized
    public boolean requiresModuleInstance() {
        return super.requiresModuleInstance();
    }

    public static Builder builder() {
        return new .AutoValue_ProductionBinding.Builder().nullability(Nullability.NOT_NULLABLE).explicitDependencies((Iterable<DependencyRequest>)ImmutableList.of()).thrownTypes((Iterable<XType>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    @Memoized
    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    @AutoValue.Builder
    public static abstract class Builder
    extends ContributionBinding.Builder<ProductionBinding, Builder> {
        @Override
        @CanIgnoreReturnValue
        public Builder dependencies(Iterable<DependencyRequest> dependencies) {
            return this.explicitDependencies(dependencies);
        }

        abstract Builder explicitDependencies(Iterable<DependencyRequest> var1);

        abstract Builder productionKind(ProductionKind var1);

        @Override
        public abstract Builder unresolved(ProductionBinding var1);

        abstract Builder thrownTypes(Iterable<XType> var1);

        abstract Builder executorRequest(DependencyRequest var1);

        abstract Builder monitorRequest(DependencyRequest var1);
    }

    public static enum ProductionKind {
        IMMEDIATE,
        FUTURE,
        SET_OF_FUTURE;


        public static ProductionKind fromProducesMethod(XMethodElement producesMethod) {
            if (TypeNames.isFutureType(producesMethod.getReturnType())) {
                return FUTURE;
            }
            if (ContributionType.fromBindingElement((XElement)producesMethod).equals((Object)ContributionType.SET_VALUES) && TypeNames.isFutureType(SetType.from(producesMethod.getReturnType()).elementType())) {
                return SET_OF_FUTURE;
            }
            return IMMEDIATE;
        }
    }
}

