/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.validation;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import dagger.internal.codegen.base.ClearableCache;
import dagger.internal.codegen.base.ComponentCreatorAnnotation;
import dagger.internal.codegen.base.Util;
import dagger.internal.codegen.binding.ErrorMessages;
import dagger.internal.codegen.binding.MethodSignatureFormatter;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.internal.codegen.xprocessing.XMethodElements;
import dagger.internal.codegen.xprocessing.XTypeElements;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;

@Singleton
public final class ComponentCreatorValidator
implements ClearableCache {
    private final Map<XTypeElement, ValidationReport> reports = new HashMap<XTypeElement, ValidationReport>();
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final KotlinMetadataUtil metadataUtil;

    @Inject
    ComponentCreatorValidator(MethodSignatureFormatter methodSignatureFormatter, KotlinMetadataUtil metadataUtil) {
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.metadataUtil = metadataUtil;
    }

    @Override
    public void clearCache() {
        this.reports.clear();
    }

    public ValidationReport validate(XTypeElement type) {
        return Util.reentrantComputeIfAbsent(this.reports, type, this::validateUncached);
    }

    private ValidationReport validateUncached(XTypeElement type) {
        ValidationReport.Builder report = ValidationReport.about((XElement)type);
        ImmutableSet<ComponentCreatorAnnotation> creatorAnnotations = ComponentCreatorAnnotation.getCreatorAnnotations(type);
        if (!this.validateOnlyOneCreatorAnnotation(creatorAnnotations, report)) {
            return report.build();
        }
        ElementValidator validator = new ElementValidator(type, report, (ComponentCreatorAnnotation)((Object)Iterables.getOnlyElement(creatorAnnotations)));
        return validator.validate();
    }

    private boolean validateOnlyOneCreatorAnnotation(ImmutableSet<ComponentCreatorAnnotation> creatorAnnotations, ValidationReport.Builder report) {
        if (creatorAnnotations.size() > 1) {
            String error = "May not have more than one component Factory or Builder annotation on a type: found " + creatorAnnotations;
            report.addError(error);
            return false;
        }
        return true;
    }

    private final class ElementValidator {
        private final XTypeElement creator;
        private final ValidationReport.Builder report;
        private final ComponentCreatorAnnotation annotation;
        private final ErrorMessages.ComponentCreatorMessages messages;

        private ElementValidator(XTypeElement creator, ValidationReport.Builder report, ComponentCreatorAnnotation annotation) {
            this.creator = creator;
            this.report = report;
            this.annotation = annotation;
            this.messages = ErrorMessages.creatorMessagesFor(annotation);
        }

        final ValidationReport validate() {
            XTypeElement enclosingType = this.creator.getEnclosingTypeElement();
            if (enclosingType == null || !enclosingType.hasAnnotation(this.annotation.componentAnnotation())) {
                return this.report.addError(this.messages.mustBeInComponent()).build();
            }
            if (!this.validateIsClassOrInterface()) {
                return this.report.build();
            }
            if (!this.validateTypeRequirements()) {
                return this.report.build();
            }
            switch (this.annotation.creatorKind()) {
                case FACTORY: {
                    this.validateFactory();
                    break;
                }
                case BUILDER: {
                    this.validateBuilder();
                }
            }
            return this.report.build();
        }

        private boolean validateIsClassOrInterface() {
            if (this.creator.isClass()) {
                this.validateConstructor();
                return true;
            }
            if (this.creator.isInterface()) {
                return true;
            }
            this.report.addError(this.messages.mustBeClassOrInterface());
            return false;
        }

        private void validateConstructor() {
            List constructors = this.creator.getConstructors();
            boolean valid = true;
            if (constructors.size() != 1) {
                valid = false;
            } else {
                XConstructorElement constructor = (XConstructorElement)Iterables.getOnlyElement((Iterable)constructors);
                boolean bl = valid = constructor.getParameters().isEmpty() && !constructor.isPrivate();
            }
            if (!valid) {
                this.report.addError(this.messages.invalidConstructor());
            }
        }

        private boolean validateTypeRequirements() {
            boolean isClean = true;
            if (XTypeElements.hasTypeParameters(this.creator)) {
                this.report.addError(this.messages.generics());
                isClean = false;
            }
            if (this.creator.isPrivate()) {
                this.report.addError(this.messages.isPrivate());
                isClean = false;
            }
            if (!this.creator.isStatic()) {
                this.report.addError(this.messages.mustBeStatic());
                isClean = false;
            }
            if (!this.creator.isAbstract()) {
                this.report.addError(this.messages.mustBeAbstract());
                isClean = false;
            }
            return isClean;
        }

        private void validateBuilder() {
            this.validateClassMethodName();
            XMethodElement buildMethod = null;
            block4: for (XMethodElement method : XTypeElements.getAllUnimplementedMethods(this.creator)) {
                switch (method.getParameters().size()) {
                    case 0: {
                        if (this.validateFactoryMethodReturnType(method) && buildMethod != null) {
                            this.error(method, this.messages.twoFactoryMethods(), this.messages.inheritedTwoFactoryMethods(), ComponentCreatorValidator.this.methodSignatureFormatter.format((XExecutableElement)buildMethod));
                        }
                        buildMethod = method;
                        continue block4;
                    }
                    case 1: {
                        this.validateSetterMethod(method);
                        continue block4;
                    }
                }
                this.error(method, this.messages.setterMethodsMustTakeOneArg(), this.messages.inheritedSetterMethodsMustTakeOneArg(), new Object[0]);
            }
            if (buildMethod == null) {
                this.report.addError(this.messages.missingFactoryMethod());
            } else {
                this.validateNotGeneric(buildMethod);
            }
        }

        private void validateClassMethodName() {
            if (ComponentCreatorValidator.this.metadataUtil.hasMetadata((XElement)this.creator)) {
                ComponentCreatorValidator.this.metadataUtil.getAllMethodNamesBySignature(this.creator).forEach((signature, name) -> {
                    if (SourceVersion.isKeyword(name)) {
                        this.report.addError("Can not use a Java keyword as method name: " + signature);
                    }
                });
            }
        }

        private void validateSetterMethod(XMethodElement method) {
            boolean bindsInstance;
            XType returnType = method.asMemberOf(this.creator.getType()).getReturnType();
            if (!XTypeKt.isVoid((XType)returnType) && !XTypes.isSubtype(this.creator.getType(), returnType)) {
                this.error(method, this.messages.setterMethodsMustReturnVoidOrBuilder(), this.messages.inheritedSetterMethodsMustReturnVoidOrBuilder(), new Object[0]);
            }
            this.validateNotGeneric(method);
            XExecutableParameterElement parameter = (XExecutableParameterElement)method.getParameters().get(0);
            boolean methodIsBindsInstance = method.hasAnnotation(XTypeNames.BINDS_INSTANCE);
            boolean parameterIsBindsInstance = parameter.hasAnnotation(XTypeNames.BINDS_INSTANCE);
            boolean bl = bindsInstance = methodIsBindsInstance || parameterIsBindsInstance;
            if (methodIsBindsInstance && parameterIsBindsInstance) {
                this.error(method, this.messages.bindsInstanceNotAllowedOnBothSetterMethodAndParameter(), this.messages.inheritedBindsInstanceNotAllowedOnBothSetterMethodAndParameter(), new Object[0]);
            }
            if (!bindsInstance && XTypes.isPrimitive(parameter.getType())) {
                this.error(method, this.messages.nonBindsInstanceParametersMayNotBePrimitives(), this.messages.inheritedNonBindsInstanceParametersMayNotBePrimitives(), new Object[0]);
            }
        }

        private void validateFactory() {
            ImmutableList<XMethodElement> abstractMethods = XTypeElements.getAllUnimplementedMethods(this.creator);
            switch (abstractMethods.size()) {
                case 0: {
                    this.report.addError(this.messages.missingFactoryMethod());
                    return;
                }
                case 1: {
                    break;
                }
                default: {
                    this.error((XMethodElement)abstractMethods.get(1), this.messages.twoFactoryMethods(), this.messages.inheritedTwoFactoryMethods(), ComponentCreatorValidator.this.methodSignatureFormatter.format((XExecutableElement)abstractMethods.get(0)));
                    return;
                }
            }
            this.validateFactoryMethod((XMethodElement)Iterables.getOnlyElement(abstractMethods));
        }

        private void validateFactoryMethod(XMethodElement method) {
            this.validateNotGeneric(method);
            if (!this.validateFactoryMethodReturnType(method)) {
                return;
            }
            for (XExecutableParameterElement parameter : method.getParameters()) {
                if (parameter.hasAnnotation(XTypeNames.BINDS_INSTANCE) || !XTypes.isPrimitive(parameter.getType())) continue;
                this.error(method, this.messages.nonBindsInstanceParametersMayNotBePrimitives(), this.messages.inheritedNonBindsInstanceParametersMayNotBePrimitives(), new Object[0]);
            }
        }

        private boolean validateFactoryMethodReturnType(XMethodElement method) {
            ImmutableSet declaredMethods;
            XTypeElement component = this.creator.getEnclosingTypeElement();
            XType returnType = method.asMemberOf(this.creator.getType()).getReturnType();
            if (!XTypes.isSubtype(component.getType(), returnType)) {
                this.error(method, this.messages.factoryMethodMustReturnComponentType(), this.messages.inheritedFactoryMethodMustReturnComponentType(), new Object[0]);
                return false;
            }
            if (method.hasAnnotation(XTypeNames.BINDS_INSTANCE)) {
                this.error(method, this.messages.factoryMethodMayNotBeAnnotatedWithBindsInstance(), this.messages.inheritedFactoryMethodMayNotBeAnnotatedWithBindsInstance(), new Object[0]);
                return false;
            }
            if (!returnType.isSameType(component.getType()) && !(declaredMethods = ImmutableSet.copyOf((Collection)component.getDeclaredMethods())).isEmpty()) {
                this.report.addWarning(this.messages.factoryMethodReturnsSupertypeWithMissingMethods(component, this.creator, returnType, method, (ImmutableCollection<XMethodElement>)declaredMethods), (XElement)method);
            }
            return true;
        }

        private void error(XMethodElement method, String enclosedError, String inheritedError, Object ... extraArgs) {
            if (method.getEnclosingElement().equals((Object)this.creator)) {
                this.report.addError(String.format(enclosedError, extraArgs), (XElement)method);
            } else {
                this.report.addError(String.format(inheritedError, ObjectArrays.concat((Object[])extraArgs, (Object)ComponentCreatorValidator.this.methodSignatureFormatter.format((XExecutableElement)method))));
            }
        }

        private void validateNotGeneric(XMethodElement method) {
            if (XMethodElements.hasTypeParameters(method)) {
                this.error(method, this.messages.methodsMayNotHaveTypeParameters(), this.messages.inheritedMethodsMayNotHaveTypeParameters(), new Object[0]);
            }
        }
    }
}

