/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.TypeName;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.ComponentDependencyProvisionBinding;
import dagger.internal.codegen.binding.ComponentRequirement;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentProvisionRequestRepresentation;
import dagger.internal.codegen.writing.ComponentRequirementExpressions;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import java.util.Collection;
import javax.lang.model.element.Modifier;

final class DependencyMethodProviderCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ComponentRequirementExpressions componentRequirementExpressions;
    private final CompilerOptions compilerOptions;
    private final BindingGraph graph;
    private final ComponentDependencyProvisionBinding binding;
    private final XMethodElement provisionMethod;

    @AssistedInject
    DependencyMethodProviderCreationExpression(@Assisted ComponentDependencyProvisionBinding binding, ComponentImplementation componentImplementation, ComponentRequirementExpressions componentRequirementExpressions, CompilerOptions compilerOptions, BindingGraph graph) {
        this.binding = (ComponentDependencyProvisionBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.componentRequirementExpressions = componentRequirementExpressions;
        this.compilerOptions = compilerOptions;
        this.graph = graph;
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        Preconditions.checkArgument((boolean)XElementKt.isMethod((XElement)binding.bindingElement().get()));
        this.provisionMethod = XElements.asMethod(binding.bindingElement().get());
    }

    @Override
    public XCodeBlock creationExpression() {
        XCodeBlock invocation = ComponentProvisionRequestRepresentation.maybeCheckForNull(this.binding, this.compilerOptions, XCodeBlock.of((String)"%N.%N()", (Object[])new Object[]{this.dependency().variableName(), this.provisionMethod.getJvmName()}));
        XClassName dependencyClassName = this.dependency().typeElement().asClassName();
        XTypeName keyType = this.binding.key().type().xprocessing().asTypeName();
        XFunSpecs.Builder getMethod = XFunSpecs.methodBuilder("get").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(XTypeNames.withTypeNullability(keyType, this.binding.nullability())).addStatement("return %L", invocation).addAnnotationNames((Collection<XClassName>)this.binding.nullability().nonTypeUseNullableAnnotations());
        ComponentImplementation.ShardImplementation componentShard = this.shardImplementation.getComponentImplementation().getComponentShard();
        XClassName factoryClassName = componentShard.name().nestedClass(componentShard.getUniqueClassName(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, XElements.getSimpleName((XElement)this.provisionMethod) + "Provider")));
        componentShard.addType(ComponentImplementation.TypeSpecKind.COMPONENT_PROVISION_FACTORY, XTypeSpecs.classBuilder(factoryClassName).addSuperinterface(XTypeNames.daggerProviderOf(XTypeNames.withTypeNullability(keyType, this.binding.nullability()))).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addField((TypeName)XConverters.toJavaPoet((XClassName)dependencyClassName), this.dependency().variableName(), Modifier.PRIVATE, Modifier.FINAL).addFunction(XFunSpecs.constructorBuilder().addParameter(this.dependency().variableName(), (XTypeName)dependencyClassName).addStatement("this.%1N = %1N", this.dependency().variableName()).build()).addFunction(getMethod.build()).build());
        return XCodeBlock.ofNewInstance((XTypeName)factoryClassName, (String)"%L", (Object[])new Object[]{this.componentRequirementExpressions.getExpressionDuringInitialization(this.dependency(), this.shardImplementation.name())});
    }

    private ComponentRequirement dependency() {
        return this.graph.componentDescriptor().getDependencyThatDefinesMethod((XElement)this.provisionMethod);
    }

    @AssistedFactory
    static interface Factory {
        public DependencyMethodProviderCreationExpression create(ComponentDependencyProvisionBinding var1);
    }
}

