/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeNameKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XConstructorType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.stream.Collectors;

public final class XExecutableTypes {
    public static boolean isSubsignature(XExecutableElement method1, XExecutableElement method2) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv((XElement)method1);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XExecutableTypes.isSubsignatureJavac(method1, method2, processingEnv);
            }
            case KSP: {
                return XExecutableTypes.isSubsignatureKsp(method1, method2);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + processingEnv.getBackend()));
    }

    private static boolean isSubsignatureKsp(XExecutableElement method1, XExecutableElement method2) {
        ImmutableList<TypeName> method2TypeParameters;
        if (method1.getParameters().size() != method2.getParameters().size()) {
            return false;
        }
        ImmutableList<TypeName> method1Parameters = XExecutableTypes.getParameters(method1);
        ImmutableList<TypeName> method1TypeParameters = XExecutableTypes.getTypeParameters(method1);
        return method1TypeParameters.equals(method2TypeParameters = XExecutableTypes.getTypeParameters(method2)) && method1Parameters.equals(XExecutableTypes.getParameters(method2)) || method1TypeParameters.isEmpty() && method1Parameters.equals(method2.getExecutableType().getParameterTypes().stream().map(XTypes::erasedTypeName).collect(DaggerStreams.toImmutableList()));
    }

    private static ImmutableList<TypeName> getParameters(XExecutableElement method) {
        return (ImmutableList)method.getExecutableType().getParameterTypes().stream().map(XType::asTypeName).map(XTypeNameKt::toJavaPoet).collect(DaggerStreams.toImmutableList());
    }

    private static ImmutableList<TypeName> getTypeParameters(XExecutableElement method) {
        return (ImmutableList)method.getTypeParameters().stream().map(it -> (XType)it.getBounds().get(0)).map(XType::asTypeName).map(XTypeNameKt::toJavaPoet).collect(DaggerStreams.toImmutableList());
    }

    private static boolean isSubsignatureJavac(XExecutableElement method1, XExecutableElement method2, XProcessingEnv env) {
        return XConverters.toJavac((XProcessingEnv)env).getTypeUtils().isSubsignature(XConverters.toJavac((XExecutableType)method1.getExecutableType()), XConverters.toJavac((XExecutableType)method2.getExecutableType()));
    }

    public static boolean isConstructorType(XExecutableType executableType) {
        return executableType instanceof XConstructorType;
    }

    public static boolean isMethodType(XExecutableType executableType) {
        return executableType instanceof XMethodType;
    }

    public static XMethodType asMethodType(XExecutableType executableType) {
        return (XMethodType)executableType;
    }

    public static String getKindName(XExecutableType executableType) {
        if (XExecutableTypes.isMethodType(executableType)) {
            return "METHOD";
        }
        if (XExecutableTypes.isConstructorType(executableType)) {
            return "CONSTRUCTOR";
        }
        return "UNKNOWN";
    }

    public static String toStableString(XExecutableType executableType) {
        try {
            return String.format("(%s)%s", executableType.getParameterTypes().stream().map(XTypes::toStableString).collect(Collectors.joining(",")), XExecutableTypes.isMethodType(executableType) ? XTypes.toStableString(XExecutableTypes.asMethodType(executableType).getReturnType()) : TypeName.VOID);
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    private XExecutableTypes() {
    }
}

