/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.base.UniqueNameSet;
import dagger.internal.codegen.binding.ProductionBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.model.RequestKind;
import dagger.internal.codegen.writing.GwtCompatibility;
import dagger.internal.codegen.writing.InjectionMethods;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.XAnnotationSpecs;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XParameterSpecs;
import dagger.internal.codegen.xprocessing.XPropertySpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.internal.codegen.xprocessing.XTypeSpecs;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room.compiler.codegen.XTypeSpec;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

public final class ProducerFactoryGenerator
extends SourceFileGenerator<ProductionBinding> {
    private final CompilerOptions compilerOptions;
    private final SourceFiles sourceFiles;

    @Inject
    ProducerFactoryGenerator(XFiler filer, XProcessingEnv processingEnv, CompilerOptions compilerOptions, SourceFiles sourceFiles) {
        super(filer, processingEnv);
        this.compilerOptions = compilerOptions;
        this.sourceFiles = sourceFiles;
    }

    @Override
    public XElement originatingElement(ProductionBinding binding) {
        return binding.bindingElement().get();
    }

    @Override
    public ImmutableList<XTypeSpec> topLevelTypes(ProductionBinding binding) {
        Preconditions.checkArgument((!binding.unresolved().isPresent() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)binding.bindingElement().isPresent());
        FactoryFields factoryFields = FactoryFields.create(binding, this.compilerOptions);
        XTypeSpecs.Builder factoryBuilder = XTypeSpecs.classBuilder(SourceFiles.generatedClassNameForBinding(binding)).superclass(XTypeNames.ABSTRACT_PRODUCES_METHOD_PRODUCER.parametrizedBy(this.callProducesMethodParameter(binding).getType(), binding.contributedType().asTypeName())).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypeVariableNames((Collection<XTypeName>)SourceFiles.bindingTypeElementTypeVariableNames(binding)).addProperties((Collection)factoryFields.getAll().stream().filter(field -> !field.equals(factoryFields.executorField)).filter(field -> !field.equals(factoryFields.monitorField)).collect(DaggerStreams.toImmutableList())).addFunction(this.constructorMethod(binding, factoryFields)).addFunction(this.staticCreateMethod(binding, factoryFields)).addFunction(this.collectDependenciesMethod(binding, factoryFields)).addFunction(this.callProducesMethod(binding, factoryFields));
        GwtCompatibility.gwtIncompatibleAnnotation(binding).ifPresent(factoryBuilder::addAnnotation);
        return ImmutableList.of((Object)factoryBuilder.build());
    }

    private XFunSpec constructorMethod(ProductionBinding binding, FactoryFields factoryFields) {
        XFunSpecs.Builder constructorBuilder = XFunSpecs.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameters((Collection<XParameterSpec>)this.constructorParameters(binding, factoryFields));
        constructorBuilder.addStatement("super(%N, %L, %N)", factoryFields.monitorField, this.producerTokenConstruction(SourceFiles.generatedClassNameForBinding(binding), binding), factoryFields.executorField);
        factoryFields.getAll().stream().filter(field -> !field.equals(factoryFields.executorField)).filter(field -> !field.equals(factoryFields.monitorField)).forEach(field -> {
            if (field.getType().getRawTypeName().equals(XTypeNames.PRODUCER)) {
                constructorBuilder.addStatement("this.%1N = %2T.nonCancellationPropagatingViewOf(%1N)", field, XTypeNames.PRODUCERS);
            } else {
                constructorBuilder.addStatement("this.%1N = %1N", field);
            }
        });
        return constructorBuilder.build();
    }

    ImmutableList<XParameterSpec> constructorParameters(ProductionBinding binding, FactoryFields factoryFields) {
        return (ImmutableList)factoryFields.getAll().stream().map(field -> XParameterSpecs.of(field.getName(), field.getType())).collect(DaggerStreams.toImmutableList());
    }

    private XFunSpec staticCreateMethod(ProductionBinding binding, FactoryFields factoryFields) {
        XFunSpecs.Builder createMethodBuilder = XFunSpecs.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding)).addTypeVariableNames((Collection<XTypeName>)SourceFiles.bindingTypeElementTypeVariableNames(binding));
        ImmutableList.Builder arguments = ImmutableList.builder();
        factoryFields.moduleField.ifPresent(module -> {
            String moduleName = module.getName();
            XType moduleType = binding.bindingTypeElement().get().getType();
            arguments.add((Object)InjectionMethods.copyParameter(createMethodBuilder, moduleName, moduleType.asTypeName(), Nullability.NOT_NULLABLE, Accessibility.isTypeAccessibleFromPublicApi(moduleType, this.compilerOptions), this.compilerOptions));
        });
        factoryFields.frameworkFields.forEach((dependencyRequest, field) -> {
            String parameterName = field.getName();
            XType dependencyType = dependencyRequest.key().type().xprocessing();
            arguments.add((Object)InjectionMethods.copyFrameworkParameter(createMethodBuilder, parameterName, field.getType(), Nullability.NOT_NULLABLE, Accessibility.isTypeAccessibleFromPublicApi(dependencyType, this.compilerOptions), this.compilerOptions));
        });
        return createMethodBuilder.addStatement("return %L", XCodeBlock.ofNewInstance(SourceFiles.parameterizedGeneratedTypeNameForBinding(binding), "%L", XCodeBlocks.makeParametersCodeBlock((Iterable<XCodeBlock>)arguments.build()))).build();
    }

    public XFunSpec collectDependenciesMethod(ProductionBinding binding, FactoryFields factoryFields) {
        XFunSpecs.Builder methodBuilder = XFunSpecs.methodBuilder("collectDependencies").isOverride(true).addModifiers(Modifier.PROTECTED);
        ImmutableList<DependencyRequest> asyncDependencies = ProducerFactoryGenerator.asyncDependencies(binding);
        switch (asyncDependencies.size()) {
            case 0: {
                return methodBuilder.returns(XTypeNames.listenableFutureOf(XTypeNames.UNIT_VOID_CLASS)).addStatement("return %T.<%T>immediateFuture(null)", XTypeNames.FUTURES, XTypeNames.UNIT_VOID_CLASS).build();
            }
            case 1: {
                DependencyRequest asyncDependency = (DependencyRequest)Iterables.getOnlyElement(asyncDependencies);
                XPropertySpec asyncDependencyField = factoryFields.get(asyncDependency);
                return methodBuilder.returns(XTypeNames.listenableFutureOf(ProducerFactoryGenerator.asyncDependencyType(asyncDependency))).addStatement("return %L", this.producedCodeBlock(asyncDependency, asyncDependencyField)).build();
            }
        }
        XCodeBlock.Builder argAssignments = XCodeBlock.builder();
        ImmutableList.Builder argNames = ImmutableList.builder();
        for (DependencyRequest asyncDependency : asyncDependencies) {
            XPropertySpec asyncDependencyField = factoryFields.get(asyncDependency);
            argNames.add((Object)XCodeBlock.of("%N", ProducerFactoryGenerator.dependencyFutureName(asyncDependency)));
            argAssignments.addLocalVal(ProducerFactoryGenerator.dependencyFutureName(asyncDependency), XTypeNames.listenableFutureOf(ProducerFactoryGenerator.asyncDependencyType(asyncDependency)), "%L", this.producedCodeBlock(asyncDependency, asyncDependencyField));
        }
        return methodBuilder.returns(XTypeNames.listenableFutureOf(XTypeNames.listOf(XTypeName.ANY_OBJECT))).addCode(argAssignments.build()).addStatement("return %T.<%T>allAsList(%L)", XTypeNames.FUTURES, XTypeName.ANY_OBJECT, XCodeBlocks.makeParametersCodeBlock((Iterable<XCodeBlock>)argNames.build())).build();
    }

    private XCodeBlock producedCodeBlock(DependencyRequest request, XPropertySpec field) {
        return request.kind() == RequestKind.PRODUCED ? XCodeBlock.of("%T.createFutureProduced(%N.get())", XTypeNames.PRODUCERS, field) : XCodeBlock.of("%N.get()", field);
    }

    private XFunSpec callProducesMethod(ProductionBinding binding, FactoryFields factoryFields) {
        XTypeName contributedTypeName = binding.contributedType().asTypeName();
        XParameterSpec parameter = this.callProducesMethodParameter(binding);
        XFunSpecs.Builder methodBuilder = XFunSpecs.methodBuilder("callProducesMethod").returns(XTypeNames.listenableFutureOf(contributedTypeName)).isOverride(true).addModifiers(Modifier.PUBLIC).addExceptions(XElements.asMethod(binding.bindingElement().get()).getThrownTypes()).addParameter(parameter);
        ImmutableList<DependencyRequest> asyncDependencies = ProducerFactoryGenerator.asyncDependencies(binding);
        ImmutableList.Builder parameterCodeBlocks = ImmutableList.builder();
        for (DependencyRequest dependency : binding.explicitDependencies()) {
            if (ProducerFactoryGenerator.isAsyncDependency(dependency)) {
                if (asyncDependencies.size() > 1) {
                    XTypeName dependencyType = ProducerFactoryGenerator.asyncDependencyType(dependency);
                    int argIndex = asyncDependencies.indexOf((Object)dependency);
                    parameterCodeBlocks.add((Object)XCodeBlock.ofCast(dependencyType, XCodeBlock.of("%N.get(%L)", parameter.getName(), argIndex)));
                    continue;
                }
                parameterCodeBlocks.add((Object)XCodeBlock.of("%N", parameter.getName()));
                continue;
            }
            parameterCodeBlocks.add((Object)this.sourceFiles.frameworkTypeUsageStatement(XCodeBlock.of("%N", factoryFields.get(dependency)), dependency.kind()));
        }
        if (asyncDependencies.size() > 1) {
            methodBuilder.addAnnotation(XAnnotationSpecs.suppressWarnings(XAnnotationSpecs.Suppression.UNCHECKED, new XAnnotationSpecs.Suppression[0]));
        }
        XCodeBlock moduleCodeBlock = XCodeBlock.of("%L.%N(%L)", factoryFields.moduleField.isPresent() ? ((XPropertySpec)factoryFields.moduleField.get()).getName() : XCodeBlock.of("%T", binding.bindingTypeElement().get().asClassName()), XElements.getSimpleName(binding.bindingElement().get()), XCodeBlocks.makeParametersCodeBlock((Iterable<XCodeBlock>)parameterCodeBlocks.build()));
        switch (ProductionKind.fromProducesMethod(XElements.asMethod(binding.bindingElement().get())).ordinal()) {
            case 0: {
                methodBuilder.addStatement("return %T.<%T>immediateFuture(%L)", XTypeNames.FUTURES, contributedTypeName, moduleCodeBlock);
                break;
            }
            case 1: {
                methodBuilder.addStatement("return %L", moduleCodeBlock);
                break;
            }
            case 2: {
                methodBuilder.addStatement("return %T.allAsSet(%L)", XTypeNames.PRODUCERS, moduleCodeBlock);
            }
        }
        return methodBuilder.build();
    }

    private XParameterSpec callProducesMethodParameter(ProductionBinding binding) {
        ImmutableList<DependencyRequest> asyncDependencies = ProducerFactoryGenerator.asyncDependencies(binding);
        switch (asyncDependencies.size()) {
            case 0: {
                return XParameterSpecs.of("ignoredVoidArg", XTypeNames.UNIT_VOID_CLASS);
            }
            case 1: {
                DependencyRequest asyncDependency = (DependencyRequest)Iterables.getOnlyElement(asyncDependencies);
                String argName = XElements.getSimpleName(asyncDependency.requestElement().get().xprocessing());
                return XParameterSpecs.of(argName.equals("module") ? "moduleArg" : argName, ProducerFactoryGenerator.asyncDependencyType(asyncDependency));
            }
        }
        return XParameterSpecs.of("args", XTypeNames.listOf(XTypeName.ANY_OBJECT));
    }

    private static ImmutableList<DependencyRequest> asyncDependencies(ProductionBinding binding) {
        return (ImmutableList)binding.dependencies().stream().filter(ProducerFactoryGenerator::isAsyncDependency).collect(DaggerStreams.toImmutableList());
    }

    private XCodeBlock producerTokenConstruction(XClassName generatedTypeName, ProductionBinding binding) {
        XCodeBlock producerTokenArgs = this.compilerOptions.writeProducerNameInToken() ? XCodeBlock.of("%S", String.format("%s#%s", binding.bindingTypeElement().get().getClassName(), XElements.getSimpleName(binding.bindingElement().get()))) : XCodeBlock.of("%T.class", generatedTypeName);
        return XCodeBlock.of("%T.create(%L)", XTypeNames.PRODUCER_TOKEN, producerTokenArgs);
    }

    private static String dependencyFutureName(DependencyRequest dependency) {
        return XElements.getSimpleName(dependency.requestElement().get().xprocessing()) + "Future";
    }

    private static boolean isAsyncDependency(DependencyRequest dependency) {
        switch (dependency.kind()) {
            case INSTANCE: 
            case PRODUCED: {
                return true;
            }
        }
        return false;
    }

    private static XTypeName asyncDependencyType(DependencyRequest dependency) {
        XTypeName keyName = dependency.key().type().xprocessing().asTypeName();
        switch (dependency.kind()) {
            case INSTANCE: {
                return keyName;
            }
            case PRODUCED: {
                return XTypeNames.producedOf(keyName);
            }
        }
        throw new AssertionError();
    }

    @Override
    protected ImmutableSet<XAnnotationSpecs.Suppression> warningSuppressions() {
        return ImmutableSet.of((Object)((Object)XAnnotationSpecs.Suppression.FUTURE_RETURN_VALUE_IGNORED));
    }

    private static final class FactoryFields {
        private final Optional<XPropertySpec> moduleField;
        private final XPropertySpec monitorField;
        private final XPropertySpec executorField;
        private final ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields;

        static FactoryFields create(ProductionBinding binding, CompilerOptions compilerOptions) {
            UniqueNameSet nameSet = new UniqueNameSet();
            Optional<XPropertySpec> moduleField = binding.requiresModuleInstance() ? Optional.of(FactoryFields.createField(binding.bindingTypeElement().get().getType().asTypeName(), nameSet.getUniqueName("module"))) : Optional.empty();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            SourceFiles.generateBindingFieldsForDependencies(binding, compilerOptions).forEach((dependency, field) -> builder.put(dependency, (Object)FactoryFields.createField(field.type(), nameSet.getUniqueName(field.name()))));
            return new FactoryFields(binding, moduleField, (ImmutableMap<DependencyRequest, XPropertySpec>)builder.buildOrThrow());
        }

        private static XPropertySpec createField(XTypeName type, String name) {
            return XPropertySpecs.of(name, type, Modifier.PRIVATE, Modifier.FINAL);
        }

        private FactoryFields(ProductionBinding binding, Optional<XPropertySpec> moduleField, ImmutableMap<DependencyRequest, XPropertySpec> frameworkFields) {
            this.moduleField = moduleField;
            this.monitorField = (XPropertySpec)frameworkFields.get((Object)binding.monitorRequest());
            this.executorField = (XPropertySpec)frameworkFields.get((Object)binding.executorRequest());
            this.frameworkFields = frameworkFields;
        }

        XPropertySpec get(DependencyRequest request) {
            return (XPropertySpec)this.frameworkFields.get((Object)request);
        }

        ImmutableList<XPropertySpec> getAll() {
            return this.moduleField.isPresent() ? ImmutableList.builder().add((Object)this.moduleField.get()).addAll((Iterable)this.frameworkFields.values()).build() : this.frameworkFields.values().asList();
        }
    }

    private static enum ProductionKind {
        IMMEDIATE,
        FUTURE,
        SET_OF_FUTURE;


        static ProductionKind fromProducesMethod(XMethodElement producesMethod) {
            if (XTypeNames.isFutureType(producesMethod.getReturnType())) {
                return FUTURE;
            }
            if (ContributionType.fromBindingElement(producesMethod).equals((Object)ContributionType.SET_VALUES) && XTypeNames.isFutureType(SetType.from(producesMethod.getReturnType()).elementType())) {
                return SET_OF_FUTURE;
            }
            return IMMEDIATE;
        }
    }
}

