/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.producers.Producer;
import dagger.producers.internal.CancellableProducer;
import dagger.producers.internal.CancellationListener;
import javax.inject.Provider;

public final class DelegateProducer<T>
implements CancellableProducer<T> {
    private CancellableProducer<T> delegate;

    @Override
    public ListenableFuture<T> get() {
        return this.delegate.get();
    }

    @Deprecated
    public void setDelegatedProducer(Producer<T> delegate) {
        DelegateProducer.setDelegate(this, delegate);
    }

    public static <T> void setDelegate(Producer<T> delegateProducer, Producer<T> delegate) {
        Preconditions.checkNotNull(delegate);
        DelegateProducer asDelegateProducer = (DelegateProducer)delegateProducer;
        if (asDelegateProducer.delegate != null) {
            throw new IllegalStateException();
        }
        asDelegateProducer.delegate = (CancellableProducer)delegate;
    }

    CancellableProducer<T> getDelegate() {
        return (CancellableProducer)Preconditions.checkNotNull(this.delegate);
    }

    @Override
    public void cancel(boolean mayInterruptIfRunning) {
        this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public Producer<T> newDependencyView() {
        return new ProducerView<T>(){

            @Override
            Producer<T> createDelegate() {
                return DelegateProducer.this.delegate.newDependencyView();
            }
        };
    }

    @Override
    public Producer<T> newEntryPointView(final CancellationListener cancellationListener) {
        return new ProducerView<T>(){

            @Override
            Producer<T> createDelegate() {
                return DelegateProducer.this.delegate.newEntryPointView(cancellationListener);
            }
        };
    }

    private static abstract class ProducerView<T>
    implements Producer<T> {
        private final Provider<Producer<T>> delegate = DoubleCheck.provider((Provider)new Provider<Producer<T>>(){

            public Producer<T> get() {
                return ProducerView.this.createDelegate();
            }
        });

        private ProducerView() {
        }

        abstract Producer<T> createDelegate();

        @Override
        public ListenableFuture<T> get() {
            return ((Producer)this.delegate.get()).get();
        }
    }
}

