/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.spi.model.AutoValue_Scope;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerTypeElement;

@AutoValue
public abstract class Scope {
    private static final ClassName PRODUCTION_SCOPE = ClassName.get((String)"dagger.producers", (String)"ProductionScope", (String[])new String[0]);
    private static final ClassName SINGLETON = ClassName.get((String)"jakarta.inject", (String)"Singleton", (String[])new String[0]);
    private static final ClassName SINGLETON_JAVAX = ClassName.get((String)"javax.inject", (String)"Singleton", (String[])new String[0]);
    private static final ClassName REUSABLE = ClassName.get((String)"dagger", (String)"Reusable", (String[])new String[0]);
    private static final ClassName SCOPE = ClassName.get((String)"jakarta.inject", (String)"Scope", (String[])new String[0]);
    private static final ClassName SCOPE_JAVAX = ClassName.get((String)"javax.inject", (String)"Scope", (String[])new String[0]);

    public static Scope scope(DaggerAnnotation scopeAnnotation) {
        Preconditions.checkArgument((boolean)Scope.isScope(scopeAnnotation));
        return new AutoValue_Scope(scopeAnnotation);
    }

    public static boolean isScope(DaggerAnnotation scopeAnnotation) {
        return Scope.isScope(scopeAnnotation.annotationTypeElement());
    }

    public static boolean isScope(DaggerTypeElement scopeAnnotationType) {
        return scopeAnnotationType.xprocessing().hasAnnotation(SCOPE) || scopeAnnotationType.xprocessing().hasAnnotation(SCOPE_JAVAX);
    }

    public abstract DaggerAnnotation scopeAnnotation();

    public final ClassName className() {
        return this.scopeAnnotation().className();
    }

    public final boolean isSingleton() {
        return this.isScope(SINGLETON) || this.isScope(SINGLETON_JAVAX);
    }

    public final boolean isReusable() {
        return this.isScope(REUSABLE);
    }

    public final boolean isProductionScope() {
        return this.isScope(PRODUCTION_SCOPE);
    }

    private boolean isScope(ClassName annotation) {
        return this.scopeAnnotation().className().equals((Object)annotation);
    }

    public final String toString() {
        return this.scopeAnnotation().toString();
    }
}

