/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.internal.shaded.auto.common;

import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.spi.internal.shaded.auto.common.MoreElements;
import dagger.spi.internal.shaded.auto.common.MoreStreams;
import dagger.spi.internal.shaded.auto.common.MoreTypes;
import dagger.spi.internal.shaded.auto.common.SuperficialValidation;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BasicAnnotationProcessor
extends AbstractProcessor {
    private final Set<ElementName> deferredElementNames = new LinkedHashSet<ElementName>();
    private final SetMultimap<Step, ElementName> elementsDeferredBySteps = LinkedHashMultimap.create();
    private Elements elements;
    private Messager messager;
    private ImmutableList<? extends Step> steps;

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.steps = ImmutableList.copyOf(this.steps());
    }

    @Deprecated
    protected Iterable<? extends ProcessingStep> initSteps() {
        throw new AssertionError((Object)"If steps() is not implemented, initSteps() must be.");
    }

    protected Iterable<? extends Step> steps() {
        return Iterables.transform(this.initSteps(), BasicAnnotationProcessor::asStep);
    }

    @Deprecated
    protected void postProcess() {
    }

    protected void postRound(RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.postProcess();
        }
    }

    private ImmutableSet<TypeElement> getSupportedAnnotationTypeElements() {
        Preconditions.checkState((this.steps != null ? 1 : 0) != 0);
        return this.steps.stream().flatMap(step -> this.getSupportedAnnotationTypeElements((Step)step).stream()).collect(MoreStreams.toImmutableSet());
    }

    private ImmutableSet<TypeElement> getSupportedAnnotationTypeElements(Step step) {
        return step.annotations().stream().map(this.elements::getTypeElement).filter(Objects::nonNull).collect(MoreStreams.toImmutableSet());
    }

    public final ImmutableSet<String> getSupportedAnnotationTypes() {
        Preconditions.checkState((this.steps != null ? 1 : 0) != 0);
        return this.steps.stream().flatMap(step -> step.annotations().stream()).collect(MoreStreams.toImmutableSet());
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations2, RoundEnvironment roundEnv) {
        Preconditions.checkState((this.elements != null ? 1 : 0) != 0);
        Preconditions.checkState((this.messager != null ? 1 : 0) != 0);
        Preconditions.checkState((this.steps != null ? 1 : 0) != 0);
        if (roundEnv.processingOver()) {
            this.postRound(roundEnv);
            if (!roundEnv.errorRaised()) {
                this.reportMissingElements((Set<ElementName>)ImmutableSet.builder().addAll(this.deferredElementNames).addAll((Iterable)this.elementsDeferredBySteps.values()).build());
            }
            return false;
        }
        this.process(this.validElements(roundEnv));
        this.postRound(roundEnv);
        return false;
    }

    private void process(ImmutableSetMultimap<TypeElement, Element> validElements) {
        for (Step step : this.steps) {
            ImmutableSet<TypeElement> annotationTypes = this.getSupportedAnnotationTypeElements(step);
            ImmutableSetMultimap stepElements = new ImmutableSetMultimap.Builder().putAll(this.indexByAnnotation(this.elementsDeferredBySteps.get((Object)step), annotationTypes)).putAll((Multimap)Multimaps.filterKeys(validElements, (Predicate)Predicates.in(annotationTypes))).build();
            if (stepElements.isEmpty()) {
                this.elementsDeferredBySteps.removeAll((Object)step);
                continue;
            }
            Set<? extends Element> rejectedElements = step.process(BasicAnnotationProcessor.toClassNameKeyedMultimap((SetMultimap<TypeElement, Element>)stepElements));
            this.elementsDeferredBySteps.replaceValues((Object)step, Iterables.transform(rejectedElements, ElementName::forAnnotatedElement));
        }
    }

    private void reportMissingElements(Set<ElementName> missingElementNames) {
        for (ElementName missingElementName : missingElementNames) {
            Optional<? extends Element> missingElement = missingElementName.getElement(this.elements);
            if (missingElement.isPresent()) {
                String string = String.valueOf(Ascii.toLowerCase((String)((Element)missingElement.get()).getKind().name()));
                this.messager.printMessage(Diagnostic.Kind.ERROR, this.processingErrorMessage(string.length() != 0 ? "this ".concat(string) : new String("this ")), (Element)missingElement.get());
                continue;
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, this.processingErrorMessage(missingElementName.name()));
        }
    }

    private String processingErrorMessage(String target) {
        return String.format("[%s:MiscError] %s was unable to process %s because not all of its dependencies could be resolved. Check for compilation errors or a circular dependency with generated code.", this.getClass().getSimpleName(), this.getClass().getCanonicalName(), target);
    }

    private ImmutableSetMultimap<TypeElement, Element> validElements(RoundEnvironment roundEnv) {
        ImmutableSet prevDeferredElementNames = ImmutableSet.copyOf(this.deferredElementNames);
        this.deferredElementNames.clear();
        ImmutableSetMultimap.Builder deferredElementsByAnnotationBuilder = ImmutableSetMultimap.builder();
        for (ElementName deferredElementName : prevDeferredElementNames) {
            Optional<? extends Element> deferredElement = deferredElementName.getElement(this.elements);
            if (deferredElement.isPresent()) {
                BasicAnnotationProcessor.findAnnotatedElements((Element)deferredElement.get(), this.getSupportedAnnotationTypeElements(), (ImmutableSetMultimap.Builder<TypeElement, Element>)deferredElementsByAnnotationBuilder);
                continue;
            }
            this.deferredElementNames.add(deferredElementName);
        }
        ImmutableSetMultimap deferredElementsByAnnotation = deferredElementsByAnnotationBuilder.build();
        ImmutableSetMultimap.Builder validElements = ImmutableSetMultimap.builder();
        LinkedHashSet<ElementName> validElementNames = new LinkedHashSet<ElementName>();
        for (TypeElement annotationType : this.getSupportedAnnotationTypeElements()) {
            Set<? extends Element> roundElements = roundEnv.getElementsAnnotatedWith(annotationType);
            ImmutableSet prevRoundElements = deferredElementsByAnnotation.get((Object)annotationType);
            for (Element element : Sets.union(roundElements, (Set)prevRoundElements)) {
                boolean isValidElement;
                ElementName elementName = ElementName.forAnnotatedElement(element);
                boolean bl = validElementNames.contains(elementName) || !this.deferredElementNames.contains(elementName) && SuperficialValidation.validateElement(element.getKind().equals((Object)ElementKind.PACKAGE) ? element : BasicAnnotationProcessor.getEnclosingType(element)) ? true : (isValidElement = false);
                if (isValidElement) {
                    validElements.put((Object)annotationType, (Object)element);
                    validElementNames.add(elementName);
                    continue;
                }
                this.deferredElementNames.add(elementName);
            }
        }
        return validElements.build();
    }

    private ImmutableSetMultimap<TypeElement, Element> indexByAnnotation(Set<ElementName> annotatedElements, ImmutableSet<TypeElement> annotationTypes) {
        ImmutableSetMultimap.Builder deferredElements = ImmutableSetMultimap.builder();
        for (ElementName elementName : annotatedElements) {
            Optional<? extends Element> element = elementName.getElement(this.elements);
            if (!element.isPresent()) continue;
            BasicAnnotationProcessor.findAnnotatedElements((Element)element.get(), annotationTypes, (ImmutableSetMultimap.Builder<TypeElement, Element>)deferredElements);
        }
        return deferredElements.build();
    }

    private static void findAnnotatedElements(Element element, ImmutableSet<TypeElement> annotationTypes, ImmutableSetMultimap.Builder<TypeElement, Element> annotatedElements) {
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind().isClass() || element2.getKind().isInterface()) continue;
            BasicAnnotationProcessor.findAnnotatedElements(element2, annotationTypes, annotatedElements);
        }
        if (element instanceof ExecutableElement) {
            for (Element element3 : MoreElements.asExecutable(element).getParameters()) {
                BasicAnnotationProcessor.findAnnotatedElements(element3, annotationTypes, annotatedElements);
            }
        }
        for (TypeElement typeElement2 : annotationTypes) {
            if (!BasicAnnotationProcessor.isAnnotationPresent(element, typeElement2)) continue;
            annotatedElements.put((Object)typeElement2, (Object)element);
        }
    }

    private static boolean isAnnotationPresent(Element element, TypeElement annotationType) {
        return element.getAnnotationMirrors().stream().anyMatch(mirror -> MoreTypes.asTypeElement(mirror.getAnnotationType()).equals(annotationType));
    }

    private static TypeElement getEnclosingType(Element element) {
        return element.accept(new SimpleElementVisitor8<TypeElement, Void>(){

            @Override
            protected TypeElement defaultAction(Element e, Void p) {
                return e.getEnclosingElement().accept(this, p);
            }

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }

            @Override
            public TypeElement visitPackage(PackageElement e, Void p) {
                throw new IllegalArgumentException();
            }
        }, null);
    }

    private static ImmutableSetMultimap<String, Element> toClassNameKeyedMultimap(SetMultimap<TypeElement, Element> elements) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        elements.asMap().forEach((annotation, element) -> builder.putAll((Object)annotation.getQualifiedName().toString(), (Iterable)element));
        return builder.build();
    }

    protected static Step asStep(ProcessingStep processingStep) {
        return new ProcessingStepAsStep(processingStep);
    }

    private static final class ElementName {
        private final Kind kind;
        private final String name;

        private ElementName(Kind kind2, Name name2) {
            this.kind = (Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind2)));
            this.name = name2.toString();
        }

        static ElementName forAnnotatedElement(Element element) {
            return element.getKind() == ElementKind.PACKAGE ? new ElementName(Kind.PACKAGE_NAME, MoreElements.asPackage(element).getQualifiedName()) : new ElementName(Kind.TYPE_NAME, BasicAnnotationProcessor.getEnclosingType(element).getQualifiedName());
        }

        String name() {
            return this.name;
        }

        Optional<? extends Element> getElement(Elements elements) {
            return Optional.fromNullable((Object)(this.kind == Kind.PACKAGE_NAME ? elements.getPackageElement(this.name) : elements.getTypeElement(this.name)));
        }

        public boolean equals(@Nullable Object object) {
            if (!(object instanceof ElementName)) {
                return false;
            }
            ElementName that = (ElementName)object;
            return this.kind == that.kind && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.kind, this.name});
        }

        private static enum Kind {
            PACKAGE_NAME,
            TYPE_NAME;

        }
    }

    private static class ProcessingStepAsStep
    implements Step {
        private final ProcessingStep processingStep;
        private final ImmutableMap<String, Class<? extends Annotation>> annotationsByName;

        ProcessingStepAsStep(ProcessingStep processingStep) {
            this.processingStep = processingStep;
            this.annotationsByName = processingStep.annotations().stream().collect(MoreStreams.toImmutableMap(c -> Objects.requireNonNull(c.getCanonicalName()), aClass -> aClass));
        }

        @Override
        public Set<String> annotations() {
            return this.annotationsByName.keySet();
        }

        @Override
        public Set<? extends Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
            return this.processingStep.process((SetMultimap<Class<? extends Annotation>, Element>)this.toClassKeyedMultimap((SetMultimap<String, Element>)elementsByAnnotation));
        }

        private ImmutableSetMultimap<Class<? extends Annotation>, Element> toClassKeyedMultimap(SetMultimap<String, Element> elements) {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            elements.asMap().forEach((annotationName, annotatedElements) -> {
                Class annotation = (Class)this.annotationsByName.get(annotationName);
                if (annotation != null) {
                    builder.putAll((Object)annotation, (Iterable)annotatedElements);
                }
            });
            return builder.build();
        }
    }

    @Deprecated
    public static interface ProcessingStep {
        public Set<? extends Class<? extends Annotation>> annotations();

        public Set<? extends Element> process(SetMultimap<Class<? extends Annotation>, Element> var1);
    }

    public static interface Step {
        public Set<String> annotations();

        public Set<? extends Element> process(ImmutableSetMultimap<String, Element> var1);
    }
}

