/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.lifecycle;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.savedstate.SavedStateRegistryOwner;
import dagger.Module;
import dagger.hilt.EntryPoint;
import dagger.hilt.EntryPoints;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ActivityComponent;
import dagger.hilt.android.components.ViewModelComponent;
import dagger.hilt.android.internal.builders.ViewModelComponentBuilder;
import dagger.hilt.android.internal.lifecycle.HiltViewModelAssistedMap;
import dagger.hilt.android.internal.lifecycle.HiltViewModelMap;
import dagger.hilt.android.internal.lifecycle.RetainedLifecycleImpl;
import dagger.multibindings.Multibinds;
import java.util.Map;
import javax.inject.Provider;
import kotlin.jvm.functions.Function1;

public final class HiltViewModelFactory
implements ViewModelProvider.Factory {
    public static final CreationExtras.Key<Function1<Object, ViewModel>> CREATION_CALLBACK_KEY = new CreationExtras.Key<Function1<Object, ViewModel>>(){};
    private final Map<Class<?>, Boolean> hiltViewModelKeys;
    private final ViewModelProvider.Factory delegateFactory;
    private final ViewModelProvider.Factory hiltViewModelFactory;

    public HiltViewModelFactory(@NonNull Map<Class<?>, Boolean> hiltViewModelKeys, @NonNull ViewModelProvider.Factory delegateFactory, final @NonNull ViewModelComponentBuilder viewModelComponentBuilder) {
        this.hiltViewModelKeys = hiltViewModelKeys;
        this.delegateFactory = delegateFactory;
        this.hiltViewModelFactory = new ViewModelProvider.Factory(){

            @NonNull
            public <T extends ViewModel> T create(@NonNull Class<T> modelClass, @NonNull CreationExtras extras) {
                RetainedLifecycleImpl lifecycle = new RetainedLifecycleImpl();
                ViewModelComponent component = viewModelComponentBuilder.savedStateHandle(SavedStateHandleSupport.createSavedStateHandle((CreationExtras)extras)).viewModelLifecycle(lifecycle).build();
                T viewModel = this.createViewModel(component, modelClass, extras);
                viewModel.addCloseable(lifecycle::dispatchOnCleared);
                return viewModel;
            }

            private <T extends ViewModel> T createViewModel(@NonNull ViewModelComponent component, @NonNull Class<T> modelClass, @NonNull CreationExtras extras) {
                Provider<ViewModel> provider = ((ViewModelFactoriesEntryPoint)EntryPoints.get((Object)component, ViewModelFactoriesEntryPoint.class)).getHiltViewModelMap().get(modelClass);
                Function1 creationCallback = (Function1)extras.get(CREATION_CALLBACK_KEY);
                Object assistedFactory = ((ViewModelFactoriesEntryPoint)EntryPoints.get((Object)component, ViewModelFactoriesEntryPoint.class)).getHiltViewModelAssistedMap().get(modelClass);
                if (assistedFactory == null) {
                    if (creationCallback == null) {
                        if (provider == null) {
                            throw new IllegalStateException("Expected the @HiltViewModel-annotated class " + modelClass.getName() + " to be available in the multi-binding of @HiltViewModelMap but none was found.");
                        }
                        return (T)((ViewModel)provider.get());
                    }
                    throw new IllegalStateException("Found creation callback but class " + modelClass.getName() + " does not have an assisted factory specified in @HiltViewModel.");
                }
                if (provider == null) {
                    if (creationCallback == null) {
                        throw new IllegalStateException("Found @HiltViewModel-annotated class " + modelClass.getName() + " using @AssistedInject but no creation callback was provided in CreationExtras.");
                    }
                    return (T)((ViewModel)creationCallback.invoke(assistedFactory));
                }
                throw new AssertionError((Object)("Found the @HiltViewModel-annotated class " + modelClass.getName() + " in both the multi-bindings of @HiltViewModelMap and @HiltViewModelAssistedMap."));
            }
        };
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull Class<T> modelClass, @NonNull CreationExtras extras) {
        if (this.hiltViewModelKeys.containsKey(modelClass)) {
            return (T)this.hiltViewModelFactory.create(modelClass, extras);
        }
        return (T)this.delegateFactory.create(modelClass, extras);
    }

    @NonNull
    public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
        if (this.hiltViewModelKeys.containsKey(modelClass)) {
            return (T)this.hiltViewModelFactory.create(modelClass);
        }
        return (T)this.delegateFactory.create(modelClass);
    }

    public static ViewModelProvider.Factory createInternal(@NonNull Activity activity, @NonNull SavedStateRegistryOwner owner, @Nullable Bundle defaultArgs, @NonNull ViewModelProvider.Factory delegateFactory) {
        return HiltViewModelFactory.createInternal(activity, delegateFactory);
    }

    public static ViewModelProvider.Factory createInternal(@NonNull Activity activity, @NonNull ViewModelProvider.Factory delegateFactory) {
        ActivityCreatorEntryPoint entryPoint = (ActivityCreatorEntryPoint)EntryPoints.get((Object)activity, ActivityCreatorEntryPoint.class);
        return new HiltViewModelFactory(entryPoint.getViewModelKeys(), delegateFactory, entryPoint.getViewModelComponentBuilder());
    }

    @EntryPoint
    @InstallIn(value={ActivityComponent.class})
    static interface ActivityCreatorEntryPoint {
        @HiltViewModelMap.KeySet
        public Map<Class<?>, Boolean> getViewModelKeys();

        public ViewModelComponentBuilder getViewModelComponentBuilder();
    }

    @Module
    @InstallIn(value={ViewModelComponent.class})
    static interface ViewModelModule {
        @Multibinds
        @HiltViewModelMap
        public Map<Class<?>, ViewModel> hiltViewModelMap();

        @Multibinds
        @HiltViewModelAssistedMap
        public Map<Class<?>, Object> hiltViewModelAssistedMap();
    }

    @EntryPoint
    @InstallIn(value={ViewModelComponent.class})
    public static interface ViewModelFactoriesEntryPoint {
        @HiltViewModelMap
        public Map<Class<?>, Provider<ViewModel>> getHiltViewModelMap();

        @HiltViewModelAssistedMap
        public Map<Class<?>, Object> getHiltViewModelAssistedMap();
    }
}

