/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.collect.ImmutableList;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import dagger.hilt.processor.internal.BaseProcessingStep;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.HiltProcessingEnvConfigs;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingStep;
import dagger.spi.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.ksp.KspBasicAnnotationProcessor;

public abstract class KspBaseProcessingStepProcessor
extends KspBasicAnnotationProcessor {
    private BaseProcessingStep processingStep;

    public KspBaseProcessingStepProcessor(SymbolProcessorEnvironment symbolProcessorEnvironment) {
        super(symbolProcessorEnvironment, HiltProcessingEnvConfigs.CONFIGS);
    }

    public void initialize(XProcessingEnv env) {
        HiltCompilerOptions.checkWrongAndDeprecatedOptions(env);
        this.processingStep = this.processingStep();
    }

    protected abstract BaseProcessingStep processingStep();

    public void preRound(XProcessingEnv env, XRoundEnv round) {
        this.processingStep.preRoundProcess(env, round);
    }

    public final ImmutableList<XProcessingStep> processingSteps() {
        return ImmutableList.of((Object)this.processingStep);
    }

    public void postRound(XProcessingEnv env, XRoundEnv round) {
        this.processingStep.postRoundProcess(env, round);
    }
}

