/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.customtestapplication;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.customtestapplication.CustomTestApplicationMetadata;
import dagger.hilt.android.processor.internal.customtestapplication.CustomTestApplicationProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.io.IOException;
import javax.lang.model.element.Modifier;

final class CustomTestApplicationGenerator {
    private static final ParameterSpec COMPONENT_MANAGER = ParameterSpec.builder((TypeName)ClassNames.TEST_APPLICATION_COMPONENT_MANAGER, (String)"componentManager", (Modifier[])new Modifier[0]).build();
    private final XProcessingEnv processingEnv;
    private final CustomTestApplicationMetadata metadata;

    public CustomTestApplicationGenerator(XProcessingEnv processingEnv, CustomTestApplicationMetadata metadata) {
        this.processingEnv = processingEnv;
        this.metadata = metadata;
    }

    public void generate() throws IOException {
        TypeSpec.Builder generator = TypeSpec.classBuilder((ClassName)this.metadata.appName());
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)generator, (XElement)this.metadata.element()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)this.metadata.baseAppName()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.GENERATED_COMPONENT_MANAGER, (TypeName[])new TypeName[]{TypeName.OBJECT})).addSuperinterface((TypeName)ClassNames.TEST_APPLICATION_COMPONENT_MANAGER_HOLDER).addField(FieldSpec.builder((TypeName)ClassName.OBJECT, (String)"componentManagerLock", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{ClassName.OBJECT}).build()).addField(CustomTestApplicationGenerator.getComponentManagerField()).addMethod(CustomTestApplicationGenerator.getComponentManagerMethod()).addMethod(CustomTestApplicationGenerator.getComponentMethod());
        Processors.addGeneratedAnnotation(generator, this.processingEnv, CustomTestApplicationProcessor.class);
        JavaFile javaFile = JavaFile.builder((String)this.metadata.appName().packageName(), (TypeSpec)generator.build()).build();
        this.processingEnv.getFiler().write(javaFile, XFiler.Mode.Isolating);
    }

    private static FieldSpec getComponentManagerField() {
        return FieldSpec.builder((TypeName)CustomTestApplicationGenerator.COMPONENT_MANAGER.type, (String)CustomTestApplicationGenerator.COMPONENT_MANAGER.name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.VOLATILE}).build();
    }

    private static MethodSpec getComponentMethod() {
        return MethodSpec.methodBuilder((String)"generatedComponent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)TypeName.OBJECT).addStatement("return $N().generatedComponent()", new Object[]{COMPONENT_MANAGER}).build();
    }

    private static MethodSpec getComponentManagerMethod() {
        return MethodSpec.methodBuilder((String)"componentManager").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.GENERATED_COMPONENT_MANAGER, (TypeName[])new TypeName[]{TypeName.OBJECT})).beginControlFlow("if ($N == null)", new Object[]{COMPONENT_MANAGER}).beginControlFlow("synchronized (componentManagerLock)", new Object[0]).beginControlFlow("if ($N == null)", new Object[]{COMPONENT_MANAGER}).addStatement("$N = new $T(this)", new Object[]{COMPONENT_MANAGER, CustomTestApplicationGenerator.COMPONENT_MANAGER.type}).endControlFlow().endControlFlow().endControlFlow().addStatement("return $N", new Object[]{COMPONENT_MANAGER}).build();
    }
}

