/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AutoValue_AndroidEntryPointMetadata;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.Components;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataUtil;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataUtils;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@AutoValue
public abstract class AndroidEntryPointMetadata {
    private static final ImmutableSet<ClassName> HILT_ANNOTATION_NAMES = ImmutableSet.of((Object)AndroidClassNames.HILT_ANDROID_APP, (Object)AndroidClassNames.ANDROID_ENTRY_POINT);

    public abstract XTypeElement element();

    public abstract XTypeElement baseElement();

    public abstract ClassName generatedClassName();

    public abstract boolean requiresBytecodeInjection();

    public abstract AndroidType androidType();

    public abstract Optional<AndroidEntryPointMetadata> baseMetadata();

    public abstract ImmutableSet<ClassName> installInComponents();

    public abstract TypeName componentManager();

    public abstract Optional<CodeBlock> componentManagerInitArgs();

    @Memoized
    public AndroidEntryPointMetadata rootMetadata() {
        return this.baseMetadata().map(AndroidEntryPointMetadata::rootMetadata).orElse(this);
    }

    boolean isRootMetadata() {
        return this.equals(this.rootMetadata());
    }

    public boolean allowsOptionalInjection() {
        return this.element().hasAnnotation(AndroidClassNames.OPTIONAL_INJECT);
    }

    public boolean baseAllowsOptionalInjection() {
        return this.baseMetadata().isPresent() && this.baseMetadata().get().allowsOptionalInjection();
    }

    public boolean overridesAndroidEntryPointClass() {
        return this.baseMetadata().isPresent();
    }

    public ClassName elementClassName() {
        return this.element().getClassName();
    }

    public TypeName baseClassName() {
        return this.baseElement().getType().getTypeName();
    }

    public ClassName injectorClassName() {
        return Processors.append(Processors.getEnclosedClassName(this.elementClassName()), "_GeneratedInjector");
    }

    public String injectMethodName() {
        return "inject" + Processors.getEnclosedName(this.elementClassName());
    }

    public final AnnotationSpec injectorInstallInAnnotation() {
        return Components.getInstallInAnnotationSpec(this.installInComponents());
    }

    public ParameterSpec componentManagerParam() {
        return ParameterSpec.builder((TypeName)this.componentManager(), (String)"componentManager", (Modifier[])new Modifier[0]).build();
    }

    public Modifier[] generatedClassModifiers() {
        Modifier[] modifierArray;
        if (this.element().isFromKotlin() && this.element().isPublic() && !this.element().isInternal()) {
            Modifier[] modifierArray2 = new Modifier[2];
            modifierArray2[0] = Modifier.ABSTRACT;
            modifierArray = modifierArray2;
            modifierArray2[1] = Modifier.PUBLIC;
        } else {
            Modifier[] modifierArray3 = new Modifier[1];
            modifierArray = modifierArray3;
            modifierArray3[0] = Modifier.ABSTRACT;
        }
        return modifierArray;
    }

    private static ClassName generatedClassName(XTypeElement element) {
        return Processors.prepend(Processors.getEnclosedClassName(element.getClassName()), "Hilt_");
    }

    private static ImmutableSet<XAnnotation> hiltAnnotations(XElement element) {
        return (ImmutableSet)element.getAllAnnotations().stream().filter(annotation -> HILT_ANNOTATION_NAMES.contains((Object)annotation.getClassName())).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean hasAndroidEntryPointMetadata(XElement element) {
        return !AndroidEntryPointMetadata.hiltAnnotations(element).isEmpty();
    }

    public static AndroidEntryPointMetadata of(XElement element) {
        return AndroidEntryPointMetadata.of(element, Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)element)));
    }

    public static AndroidEntryPointMetadata manuallyConstruct(XTypeElement element, XTypeElement baseElement, ClassName generatedClassName, boolean requiresBytecodeInjection, AndroidType androidType, Optional<AndroidEntryPointMetadata> baseMetadata, ImmutableSet<ClassName> installInComponents, TypeName componentManager, Optional<CodeBlock> componentManagerInitArgs) {
        return new AutoValue_AndroidEntryPointMetadata(element, baseElement, generatedClassName, requiresBytecodeInjection, androidType, baseMetadata, installInComponents, componentManager, componentManagerInitArgs);
    }

    private static AndroidEntryPointMetadata of(XElement element, LinkedHashSet<XElement> inheritanceTrace) {
        XTypeElement baseElement;
        boolean requiresBytecodeInjection;
        ImmutableSet<XAnnotation> hiltAnnotations = AndroidEntryPointMetadata.hiltAnnotations(element);
        ProcessorErrors.checkState(hiltAnnotations.size() == 1, element, "Expected exactly 1 of %s. Found: %s", HILT_ANNOTATION_NAMES.stream().map(ClassName::canonicalName).collect(DaggerStreams.toImmutableSet()), hiltAnnotations.stream().map(XAnnotations::toStableString).collect(DaggerStreams.toImmutableSet()));
        ClassName annotationClassName = ((XAnnotation)Iterables.getOnlyElement(hiltAnnotations)).getClassName();
        ProcessorErrors.checkState(XElementKt.isTypeElement((XElement)element) && XElements.asTypeElement((XElement)element).isClass(), element, "Only classes can be annotated with @%s", annotationClassName.simpleName());
        XTypeElement androidEntryPointElement = XElements.asTypeElement((XElement)element);
        ProcessorErrors.checkState(androidEntryPointElement.getTypeParameters().isEmpty(), element, "@%s-annotated classes cannot have type parameters.", annotationClassName.simpleName());
        XTypeElement androidEntryPointClassValue = androidEntryPointElement.getAnnotation(annotationClassName).getAsType("value").getTypeElement();
        ClassName generatedClassName = AndroidEntryPointMetadata.generatedClassName(androidEntryPointElement);
        boolean bl = requiresBytecodeInjection = HiltCompilerOptions.isAndroidSuperClassValidationDisabled(androidEntryPointElement) && XTypeKt.isVoidObject((XType)androidEntryPointClassValue.getType());
        if (requiresBytecodeInjection) {
            baseElement = androidEntryPointElement.getSuperClass().getTypeElement();
            KotlinMetadataUtil metadataUtil = KotlinMetadataUtils.getMetadataUtil();
            ProcessorErrors.checkState(!metadataUtil.hasMetadata((XElement)androidEntryPointElement) || !metadataUtil.containsConstructorWithDefaultParam(baseElement), (XElement)baseElement, "The base class, '%s', of the @AndroidEntryPoint, '%s', contains a constructor with default parameters. This is currently not supported by the Gradle plugin. Either specify the base class as described at https://dagger.dev/hilt/gradle-setup#why-use-the-plugin or remove the default value declaration.", baseElement.getQualifiedName(), androidEntryPointElement.getQualifiedName());
        } else {
            baseElement = androidEntryPointClassValue;
            ProcessorErrors.checkState(!XTypeKt.isVoidObject((XType)baseElement.getType()), (XElement)androidEntryPointElement, "Expected @%s to have a value. Did you forget to apply the Gradle Plugin? (com.google.dagger.hilt.android)\nSee https://dagger.dev/hilt/gradle-setup.html", annotationClassName.simpleName());
            String extendsName = androidEntryPointElement.getSuperClass().getTypeElement().getClassName().simpleName();
            if (XConverters.getProcessingEnv((XElement)androidEntryPointElement).getBackend() == XProcessingEnv.Backend.JAVAC) {
                ProcessorErrors.checkState(extendsName.contentEquals(generatedClassName.simpleName()), (XElement)androidEntryPointElement, "@%s class expected to extend %s. Found: %s", annotationClassName.simpleName(), generatedClassName.simpleName(), extendsName);
            }
        }
        Optional<AndroidEntryPointMetadata> baseMetadata = AndroidEntryPointMetadata.baseMetadata(androidEntryPointElement, baseElement, inheritanceTrace);
        if (baseMetadata.isPresent()) {
            return AndroidEntryPointMetadata.manuallyConstruct(androidEntryPointElement, baseElement, generatedClassName, requiresBytecodeInjection, baseMetadata.get().androidType(), baseMetadata, baseMetadata.get().installInComponents(), baseMetadata.get().componentManager(), baseMetadata.get().componentManagerInitArgs());
        }
        Type type = Type.of(androidEntryPointElement, baseElement);
        return AndroidEntryPointMetadata.manuallyConstruct(androidEntryPointElement, baseElement, generatedClassName, requiresBytecodeInjection, type.androidType, Optional.empty(), (ImmutableSet<ClassName>)ImmutableSet.of((Object)type.component), (TypeName)type.manager, Optional.ofNullable(type.componentManagerInitArgs));
    }

    private static Optional<AndroidEntryPointMetadata> baseMetadata(XTypeElement element, XTypeElement baseElement, LinkedHashSet<XElement> inheritanceTrace) {
        ProcessorErrors.checkState(inheritanceTrace.add((XElement)baseElement), (XElement)element, (Object)AndroidEntryPointMetadata.cyclicInheritanceErrorMessage(inheritanceTrace, baseElement));
        if (AndroidEntryPointMetadata.hasAndroidEntryPointMetadata((XElement)baseElement)) {
            AndroidEntryPointMetadata baseMetadata = AndroidEntryPointMetadata.of((XElement)baseElement, inheritanceTrace);
            AndroidEntryPointMetadata.checkConsistentAnnotations(element, baseMetadata);
            return Optional.of(baseMetadata);
        }
        XType superClass = baseElement.getSuperClass();
        if (superClass != null && !superClass.isError()) {
            Preconditions.checkState((boolean)XTypes.isDeclared((XType)superClass));
            return AndroidEntryPointMetadata.baseMetadata(element, superClass.getTypeElement(), inheritanceTrace);
        }
        return Optional.empty();
    }

    private static String cyclicInheritanceErrorMessage(LinkedHashSet<XElement> inheritanceTrace, XTypeElement cycleEntryPoint) {
        return String.format("Cyclic inheritance detected. Make sure the base class of @AndroidEntryPoint is not the annotated class itself or subclass of the annotated class.\nThe cyclic inheritance structure: %s --> %s\n", inheritanceTrace.stream().map(XElements::toStableString).collect(Collectors.joining(" --> ")), XElements.toStableString((XElement)cycleEntryPoint));
    }

    private static void checkConsistentAnnotations(XTypeElement element, AndroidEntryPointMetadata baseMetadata) {
        XTypeElement baseElement = baseMetadata.element();
        AndroidEntryPointMetadata.checkAnnotationsMatch(element, baseElement, AndroidClassNames.WITH_FRAGMENT_BINDINGS);
        ProcessorErrors.checkState(baseMetadata.allowsOptionalInjection() || !element.hasAnnotation(AndroidClassNames.OPTIONAL_INJECT), (XElement)element, "@OptionalInject Hilt class cannot extend from a non-optional @AndroidEntryPoint base: %s", XElements.toStableString((XElement)element));
    }

    private static void checkAnnotationsMatch(XTypeElement element, XTypeElement baseElement, ClassName annotationName) {
        boolean isBaseAnnotated;
        boolean isAnnotated = element.hasAnnotation(annotationName);
        ProcessorErrors.checkState(isAnnotated == (isBaseAnnotated = baseElement.hasAnnotation(annotationName)), (XElement)element, isBaseAnnotated ? "Classes that extend an @%1$s base class must also be annotated @%1$s" : "Classes that extend a @AndroidEntryPoint base class must not use @%1$s when the base class does not use @%1$s", annotationName.simpleName());
    }

    public static enum AndroidType {
        APPLICATION,
        ACTIVITY,
        BROADCAST_RECEIVER,
        FRAGMENT,
        SERVICE,
        VIEW;

    }

    private static final class Type {
        private static final Type APPLICATION = new Type(AndroidClassNames.SINGLETON_COMPONENT, AndroidType.APPLICATION, AndroidClassNames.APPLICATION_COMPONENT_MANAGER, null);
        private static final Type SERVICE = new Type(AndroidClassNames.SERVICE_COMPONENT, AndroidType.SERVICE, AndroidClassNames.SERVICE_COMPONENT_MANAGER, CodeBlock.of((String)"this", (Object[])new Object[0]));
        private static final Type BROADCAST_RECEIVER = new Type(AndroidClassNames.SINGLETON_COMPONENT, AndroidType.BROADCAST_RECEIVER, AndroidClassNames.BROADCAST_RECEIVER_COMPONENT_MANAGER, null);
        private static final Type ACTIVITY = new Type(AndroidClassNames.ACTIVITY_COMPONENT, AndroidType.ACTIVITY, AndroidClassNames.ACTIVITY_COMPONENT_MANAGER, CodeBlock.of((String)"this", (Object[])new Object[0]));
        private static final Type FRAGMENT = new Type(AndroidClassNames.FRAGMENT_COMPONENT, AndroidType.FRAGMENT, AndroidClassNames.FRAGMENT_COMPONENT_MANAGER, CodeBlock.of((String)"this", (Object[])new Object[0]));
        private static final Type VIEW = new Type(AndroidClassNames.VIEW_WITH_FRAGMENT_COMPONENT, AndroidType.VIEW, AndroidClassNames.VIEW_COMPONENT_MANAGER, CodeBlock.of((String)"this, true /* hasFragmentBindings */", (Object[])new Object[0]));
        private static final Type VIEW_NO_FRAGMENT = new Type(AndroidClassNames.VIEW_COMPONENT, AndroidType.VIEW, AndroidClassNames.VIEW_COMPONENT_MANAGER, CodeBlock.of((String)"this, false /* hasFragmentBindings */", (Object[])new Object[0]));
        final ClassName component;
        final AndroidType androidType;
        final ClassName manager;
        final CodeBlock componentManagerInitArgs;

        Type(ClassName component, AndroidType androidType, ClassName manager, CodeBlock componentManagerInitArgs) {
            this.component = component;
            this.androidType = androidType;
            this.manager = manager;
            this.componentManagerInitArgs = componentManagerInitArgs;
        }

        private static Type of(XTypeElement element, XTypeElement baseElement) {
            return element.hasAnnotation(AndroidClassNames.HILT_ANDROID_APP) ? Type.forHiltAndroidApp(element, baseElement) : Type.forAndroidEntryPoint(element, baseElement);
        }

        private static Type forHiltAndroidApp(XTypeElement element, XTypeElement baseElement) {
            ProcessorErrors.checkState(Processors.isAssignableFrom(baseElement, AndroidClassNames.APPLICATION), (XElement)element, "@HiltAndroidApp base class must extend Application. Found: %s", XElements.toStableString((XElement)baseElement));
            return APPLICATION;
        }

        private static Type forAndroidEntryPoint(XTypeElement element, XTypeElement baseElement) {
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.ACTIVITY)) {
                ProcessorErrors.checkState(Processors.isAssignableFrom(baseElement, AndroidClassNames.COMPONENT_ACTIVITY), (XElement)element, (Object)"Activities annotated with @AndroidEntryPoint must be a subclass of androidx.activity.ComponentActivity. (e.g. FragmentActivity, AppCompatActivity, etc.)");
                return ACTIVITY;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.SERVICE)) {
                return SERVICE;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.BROADCAST_RECEIVER)) {
                return BROADCAST_RECEIVER;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.FRAGMENT)) {
                return FRAGMENT;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.VIEW)) {
                boolean withFragmentBindings = element.hasAnnotation(AndroidClassNames.WITH_FRAGMENT_BINDINGS);
                return withFragmentBindings ? VIEW : VIEW_NO_FRAGMENT;
            }
            if (Processors.isAssignableFrom(baseElement, AndroidClassNames.APPLICATION)) {
                throw new BadInputException("@AndroidEntryPoint cannot be used on an Application. Use @HiltAndroidApp instead.", (XElement)element);
            }
            throw new BadInputException("@AndroidEntryPoint base class must extend ComponentActivity, (support) Fragment, View, Service, or BroadcastReceiver.", (XElement)element);
        }
    }
}

