// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.core;

import ksp.com.intellij.openapi.roots.LanguageLevelProjectExtension;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.org.jetbrains.annotations.NotNull;


public class CoreLanguageLevelProjectExtension extends LanguageLevelProjectExtension {
  private LanguageLevel myLanguageLevel = LanguageLevel.HIGHEST;

  @NotNull
  @Override
  public LanguageLevel getLanguageLevel() {
    return myLanguageLevel;
  }

  @Override
  public void setLanguageLevel(@NotNull LanguageLevel languageLevel) {
    myLanguageLevel = languageLevel;
  }
}
