// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.diagnostic

import ksp.com.intellij.openapi.application.ApplicationManager
import ksp.com.intellij.openapi.components.service
import ksp.com.intellij.openapi.project.Project
import ksp.it.unimi.dsi.fastutil.objects.Object2IntMap
import ksp.it.unimi.dsi.fastutil.objects.Object2LongMap
import kotlinx.coroutines.flow.Flow
import ksp.org.jetbrains.annotations.ApiStatus
import java.nio.ByteBuffer

@ApiStatus.Internal
interface StartUpPerformanceService {
  companion object {
    fun getInstance(): StartUpPerformanceService = ApplicationManager.getApplication().service<StartUpPerformanceService>()
  }

  // async execution
  fun reportStatistics(project: Project)

  fun getPluginCostMap(): Map<String, Object2LongMap<String>>

  fun getMetrics(): Flow<Object2IntMap<String>>

  fun getLastReport(): ByteBuffer?

  fun projectDumbAwareActivitiesFinished() {
  }

  fun editorRestoringTillHighlighted() {
  }
}