// Copyright 2000-2024 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.util;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;

public class UnsupportedNodeElementTypeException extends IncorrectOperationException {

  public UnsupportedNodeElementTypeException(@NotNull ASTNode node) {
    super("Cannot create PSI for element type " + node.getElementType() + ". AST Node: " + node + " (" + node.getClass() + ")");
  }
}
