/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.declarations.impl

import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.builtins.StandardNames.BACKING_FIELD
import ksp.org.jetbrains.kotlin.fir.FirImplementationDetail
import ksp.org.jetbrains.kotlin.fir.FirModuleData
import ksp.org.jetbrains.kotlin.fir.MutableOrEmptyList
import ksp.org.jetbrains.kotlin.fir.builder.toMutableOrEmpty
import ksp.org.jetbrains.kotlin.fir.declarations.*
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef
import ksp.org.jetbrains.kotlin.name.CallableId

@OptIn(FirImplementationDetail::class)
class FirDefaultPropertyBackingField(
    moduleData: FirModuleData,
    origin: FirDeclarationOrigin,
    source: KtSourceElement?,
    annotations: MutableList<FirAnnotation>,
    returnTypeRef: FirTypeRef,
    isVar: Boolean,
    propertySymbol: FirPropertySymbol,
    status: FirDeclarationStatus,
    resolvePhase: FirResolvePhase = FirResolvePhase.RAW_FIR,
) : FirBackingFieldImpl(
    source = source,
    moduleData = moduleData,
    resolvePhase = resolvePhase,
    origin = origin,
    attributes = FirDeclarationAttributes(),
    returnTypeRef = returnTypeRef,
    deprecationsProvider = UnresolvedDeprecationProvider,
    name = BACKING_FIELD,
    isVar = isVar,
    isVal = !isVar,
    symbol = FirBackingFieldSymbol(),
    propertySymbol = propertySymbol,
    initializer = null,
    annotations = annotations.toMutableOrEmpty(),
    status = status,
)

