/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl

import ksp.com.intellij.psi.stubs.StubElement
import ksp.com.intellij.util.io.StringRef
import ksp.org.jetbrains.kotlin.name.FqName
import ksp.org.jetbrains.kotlin.psi.KtImplementationDetail
import ksp.org.jetbrains.kotlin.psi.KtPrimaryConstructor
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinConstructorStub
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes

@OptIn(KtImplementationDetail::class)
class KotlinPrimaryConstructorStubImpl(
    parent: StubElement<*>?,
    private val containingClassName: StringRef?,
) : KotlinStubBaseImpl<KtPrimaryConstructor>(parent, KtStubElementTypes.PRIMARY_CONSTRUCTOR),
    KotlinConstructorStub<KtPrimaryConstructor> {
    override val fqName: FqName? get() = null
    override fun getName(): String? = StringRef.toString(containingClassName)
    override val isTopLevel: Boolean get() = false
    override val isExtension: Boolean get() = false
    override val mayHaveContract: Boolean get() = false
    override val hasNoExpressionBody: Boolean get() = true
    override val hasBody: Boolean get() = false
    override val isDelegatedCallToThis: Boolean get() = false
    override val isExplicitDelegationCall: Boolean get() = false

    @KtImplementationDetail
    override fun copyInto(newParent: StubElement<*>?): KotlinPrimaryConstructorStubImpl = KotlinPrimaryConstructorStubImpl(
        parent = newParent,
        containingClassName = containingClassName,
    )
}
