/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.impl

import ksp.com.intellij.psi.stubs.StubElement
import ksp.com.intellij.util.io.StringRef
import ksp.org.jetbrains.kotlin.name.FqName
import ksp.org.jetbrains.kotlin.psi.KtImplementationDetail
import ksp.org.jetbrains.kotlin.psi.KtScript
import ksp.org.jetbrains.kotlin.psi.stubs.KotlinScriptStub
import ksp.org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes

@OptIn(KtImplementationDetail::class)
class KotlinScriptStubImpl(
    parent: StubElement<*>?,
    private val fqNameRef: StringRef,
) : KotlinStubBaseImpl<KtScript>(parent, KtStubElementTypes.SCRIPT), KotlinScriptStub {
    override fun getName(): String = fqName.shortName().asString()
    override val fqName: FqName get() = FqName(fqNameRef.string)

    @KtImplementationDetail
    override fun copyInto(newParent: StubElement<*>?): KotlinScriptStubImpl = KotlinScriptStubImpl(
        parent = newParent,
        fqNameRef = fqNameRef,
    )
}
