// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl;

import ksp.com.intellij.openapi.application.ModalityState;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public interface DocumentCommitProcessor {
  void commitSynchronously(@NotNull Document document, @NotNull Project project, @NotNull PsiFile psiFile);

  void commitAsynchronously(@NotNull Project project,
                            @NotNull PsiDocumentManagerBase documentManager,
                            @NotNull Document document,
                            @NonNls @NotNull Object reason,
                            @NotNull ModalityState modality,
                            @NotNull FileViewProvider cachedViewProvider);
}
