// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.impl.source.javadoc;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.JavaDocTokenType;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.impl.source.tree.ChildRole;
import ksp.com.intellij.psi.impl.source.tree.CompositePsiElement;
import ksp.com.intellij.psi.impl.source.tree.JavaDocElementType;
import ksp.com.intellij.psi.javadoc.JavadocManager;
import ksp.com.intellij.psi.javadoc.JavadocTagInfo;
import ksp.com.intellij.psi.javadoc.PsiDocTag;
import ksp.com.intellij.psi.javadoc.PsiDocTagValue;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiDocTagValueImpl extends CompositePsiElement implements PsiDocTagValue {
  public PsiDocTagValueImpl() {
    super(JavaDocElementType.DOC_TAG_VALUE_ELEMENT);
  }

  @Override
  public void accept(@NotNull PsiElementVisitor visitor) {
    if (visitor instanceof JavaElementVisitor) {
      ((JavaElementVisitor)visitor).visitDocTagValue(this);
    }
    else {
      visitor.visitElement(this);
    }
  }

  @Override
  public int getChildRole(@NotNull ASTNode child) {
    if (child.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_COMMA ||
        child.getElementType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN && child.getTextLength() == 1 && child.getChars().charAt(0) == ',') {
      return ChildRole.COMMA;
    }

    return super.getChildRole(child);
  }

  @Override
  public PsiReference getReference() {
    PsiDocTag docTag = PsiTreeUtil.getParentOfType(this, PsiDocTag.class);
    if (docTag == null) return null;

    JavadocTagInfo info = JavadocManager.getInstance(getProject()).getTagInfo(docTag.getName());
    if (info == null) return null;

    return info.getReference(this);
  }
}