// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.

package ksp.com.intellij.util;

import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.Collection;

public class ArrayQuery<T> implements Query<T> {
  private final T[] myArray;

  public ArrayQuery(T @NotNull ... array) {
    myArray = array;
  }

  @Override
  public @NotNull Collection<T> findAll() {
    return Arrays.asList(myArray);
  }

  @Override
  public T findFirst() {
    return myArray.length > 0 ? myArray[0] : null;
  }

  @Override
  public boolean forEach(final @NotNull Processor<? super T> consumer) {
    return ContainerUtil.process(myArray, consumer);
  }
}
