/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.contracts.description.booleans

import ksp.org.jetbrains.kotlin.analysis.api.KaExperimentalApi
import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.contracts.description.KaContractParameterValue
import ksp.org.jetbrains.kotlin.analysis.api.types.KaType

/**
 * See: [KaContractBooleanExpression].
 */
@KaExperimentalApi
@SubclassOptInRequired(KaImplementationDetail::class)
public interface KaContractIsInstancePredicateExpression : KaContractBooleanExpression {
    public val argument: KaContractParameterValue

    public val type: KaType

    public val isNegated: Boolean

    public fun negated(): KaContractIsInstancePredicateExpression
}

/**
 * See: [KaContractBooleanExpression].
 */
@KaExperimentalApi
@SubclassOptInRequired(KaImplementationDetail::class)
public interface KaContractIsNullPredicateExpression : KaContractBooleanExpression {
    public val argument: KaContractParameterValue

    public val isNegated: Boolean

    public fun negated(): KaContractIsNullPredicateExpression
}
