/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.platform.projectStructure

import ksp.com.intellij.openapi.components.service
import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.psi.search.GlobalSearchScope
import ksp.org.jetbrains.kotlin.analysis.api.platform.KaEngineService
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule

/**
 * An engine services which *must* be used to calculate a [KaModule]'s [content scope][KaModule.contentScope] lazily.
 */
public interface KaContentScopeProvider : KaEngineService {
    /**
     * Calculates a [KaModule.contentScope] from [KaModule.baseContentScope] for the given [KaModule] using [KotlinContentScopeRefiner]s.
     */
    public fun getRefinedContentScope(module: KaModule): GlobalSearchScope

    public companion object {
        public fun getInstance(project: Project): KaContentScopeProvider = project.service()
    }
}
