/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.standalone.base.declarations

import ksp.org.jetbrains.kotlin.name.CallableId
import ksp.org.jetbrains.kotlin.name.ClassId
import ksp.org.jetbrains.kotlin.name.FqName
import ksp.org.jetbrains.kotlin.name.Name
import ksp.org.jetbrains.kotlin.psi.*

internal interface KotlinStandaloneDeclarationIndex {
    val facadeFileMap: Map<FqName, Set<KtFile>>
    val multiFileClassPartMap: Map<FqName, Set<KtFile>>
    val scriptMap: Map<FqName, Set<KtScript>>

    val classesByClassId: Map<ClassId, Set<KtClassOrObject>>
    val typeAliasesByClassId: Map<ClassId, Set<KtTypeAlias>>
    val topLevelFunctionsByCallableId: Map<CallableId, Set<KtNamedFunction>>
    val topLevelPropertiesByCallableId: Map<CallableId, Set<KtProperty>>

    val classLikeDeclarationsByPackage: Map<FqName, Set<KtClassLikeDeclaration>>
    val topLevelCallablesByPackage: Map<FqName, Set<KtCallableDeclaration>>

    /**
     * Allows quickly finding [KtClassOrObject]s which have a given simple name as a supertype. The map may contain local classes as well.
     */
    val classesBySupertypeName: Map<Name, Set<KtClassOrObject>>

    /**
     * Maps a simple name `N` to type aliases `A` in whose definition `N` occurs as the topmost user type, which is a prerequisite for other
     * classes inheriting from `N` by referring to `A`. Does not support function types (e.g. `Function1`).
     *
     * There is no guarantee that the type alias can be inherited from. For example, if its expanded type is final, the type alias is not
     * inheritable. The resulting type alias `A` may also occur in the expanded type of another type alias (which may also be inheritable),
     * so the index may need to be followed transitively.
     *
     * The index is used to find direct class inheritors.
     *
     * ### Example
     *
     * ```
     * abstract class C
     *
     * typealias A = C
     *
     * class X : A()
     * ```
     *
     * The index contains the following entry: `"C" -> A`.
     */
    val inheritableTypeAliasesByAliasedName: Map<Name, Set<KtTypeAlias>>
}
