/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains

import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLCaffeineStatsCounter
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsScopes
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsService
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.getMeter

internal class LLSymbolProviderStatistics(statisticsService: LLStatisticsService) : LLStatisticsDomain {
    private val meter = statisticsService.openTelemetry.getMeter(LLStatisticsScopes.SymbolProviders)

    /**
     * A global [Caffeine stats counter][com.github.benmanes.caffeine.cache.stats.StatsCounter] for combined symbol provider *class* caches.
     */
    val combinedSymbolProviderClassCacheStatsCounter =
        LLCaffeineStatsCounter(meter, LLStatisticsScopes.SymbolProviders.Combined.Classes)

    /**
     * A global [Caffeine stats counter][com.github.benmanes.caffeine.cache.stats.StatsCounter] for combined symbol provider *callable*
     * caches.
     */
    val combinedSymbolProviderCallableCacheStatsCounter =
        LLCaffeineStatsCounter(meter, LLStatisticsScopes.SymbolProviders.Combined.Callables)
}
