/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.transformers

import ksp.org.jetbrains.kotlin.fir.FirImplementationDetail
import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.FirJumpingPhaseComputationSessionForLocalClassesProvider
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationSession
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationsComputationSession

@OptIn(FirImplementationDetail::class)
internal object LLJumpingPhaseComputationSessionForLocalClassesProvider : FirJumpingPhaseComputationSessionForLocalClassesProvider() {
    override fun compilerRequiredAnnotationPhaseSession(): CompilerRequiredAnnotationsComputationSession {
        return LLCompilerRequiredAnnotationsComputationSessionLocalClassesAware()
    }

    override fun superTypesPhaseSession(): SupertypeComputationSession {
        return LLSupertypeComputationSessionLocalClassesAware()
    }

    override fun statusPhaseSession(
        useSiteSession: FirSession,
        useSiteScopeSession: ScopeSession,
        designationMapForLocalClasses: Map<FirClassLikeDeclaration, FirClassLikeDeclaration?>,
    ): StatusComputationSession = LLStatusComputationSessionLocalClassesAware(
        useSiteSession,
        useSiteScopeSession,
    )
}
