/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.asJava.elements

import ksp.com.intellij.psi.PsiElement
import ksp.com.intellij.psi.PsiFile
import ksp.com.intellij.psi.PsiTypeParameterListOwner
import ksp.com.intellij.psi.ResolveState
import ksp.com.intellij.psi.impl.light.LightTypeParameterListBuilder
import ksp.com.intellij.psi.scope.PsiScopeProcessor
import ksp.org.jetbrains.kotlin.idea.KotlinLanguage

// Used by UastFakeSourceLightMethod
class KotlinLightTypeParameterListBuilder(private val owner: PsiTypeParameterListOwner) :
    LightTypeParameterListBuilder(owner.manager, KotlinLanguage.INSTANCE) {
    override fun processDeclarations(
        processor: PsiScopeProcessor,
        state: ResolveState,
        lastParent: PsiElement?,
        place: PsiElement
    ): Boolean {
        return typeParameters.all { processor.execute(it, state) }
    }

    override fun getParent(): PsiElement = owner
    override fun getContainingFile(): PsiFile = owner.containingFile

    override fun getText(): String? = ""
}
