/*
 * Copyright 2010-2020 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.jvm.intrinsics

import ksp.org.jetbrains.kotlin.backend.jvm.codegen.ClassCodegen
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression
import ksp.org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature
import ksp.org.jetbrains.org.objectweb.asm.Type

object ThrowKotlinNothingValueException : CallBasedIntrinsicMethod() {
    override fun toCallable(
        expression: IrFunctionAccessExpression,
        signature: JvmMethodSignature,
        classCodegen: ClassCodegen
    ): IntrinsicFunction =
        IntrinsicFunction.create(expression, signature, classCodegen) { mv ->
            mv.anew(Type.getObjectType("kotlin/KotlinNothingValueException"))
            mv.dup()
            mv.invokespecial("kotlin/KotlinNothingValueException", "<init>", "()V", false)
            mv.athrow()
        }
}
