/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.wasm.ic

import ksp.org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledFileFragment
import ksp.org.jetbrains.kotlin.backend.wasm.serialization.WasmSerializer
import ksp.org.jetbrains.kotlin.ir.backend.js.ic.IrICModule
import ksp.org.jetbrains.kotlin.ir.backend.js.ic.IrICProgramFragments
import java.io.OutputStream

class WasmIrProgramFragments(
    override val mainFragment: WasmCompiledFileFragment,
) : IrICProgramFragments() {

    override val exportFragment: WasmCompiledFileFragment? = null

    override fun serialize(stream: OutputStream) {
        WasmSerializer(stream).serialize(this.mainFragment)
    }
}

class WasmIrModule(
    override val moduleName: String,
    override val fragments: List<WasmCompiledFileFragment>,
) : IrICModule()