/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.backend.js.lower

import ksp.org.jetbrains.kotlin.backend.common.lower.InventNamesForLocalClasses
import ksp.org.jetbrains.kotlin.ir.IrElement
import ksp.org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext
import ksp.org.jetbrains.kotlin.js.common.makeValidES5Identifier
import ksp.org.jetbrains.kotlin.ir.declarations.*
import ksp.org.jetbrains.kotlin.ir.util.isAnonymousObject

class JsInventNamesForLocalClasses(private val context: JsIrBackendContext) : InventNamesForLocalClasses() {
    override fun computeTopLevelClassName(clazz: IrClass): String = clazz.name.toString()

    override fun sanitizeNameIfNeeded(name: String): String = makeValidES5Identifier(name, withHash = false)

    override fun customizeNameInventorData(clazz: IrClass, data: NameBuilder): NameBuilder {
        if (!clazz.isAnonymousObject) return data
        val customEnclosingName = (clazz.parent as? IrFile)?.packagePartClassName?.let(::sanitizeNameIfNeeded) ?: return data
        return NameBuilder(currentName = customEnclosingName, isLocal = true, processingInlinedFunction = data.processingInlinedFunction)
    }

    override fun putLocalClassName(declaration: IrElement, localClassName: String) {
        if (declaration is IrClass) {
            context.localClassNames[declaration] = localClassName
        }
    }
}
